/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemTeleportationStar
extends ItemMod {
    public ItemTeleportationStar() {
        super(new Item.Properties().durability(64));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        boolean hasInfo;
        ItemStack stack = player.getItemInHand(hand);
        boolean bl = hasInfo = stack.has(DataComponentRegistry.dimension) && stack.has(DataComponentRegistry.position);
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                stack.set(DataComponentRegistry.dimension, (Object)player.level().dimension().location());
                stack.set(DataComponentRegistry.position, (Object)player.blockPosition());
                Component message = LocalizeUtils.clientMessage("teleport.change_position", new Object[0]);
                player.displayClientMessage(message, true);
                return InteractionResultHolder.success((Object)stack);
            }
            if (hasInfo) {
                ServerLevel serverWorld = world.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)stack.get(DataComponentRegistry.dimension))));
                if (player instanceof ServerPlayer) {
                    BlockPos pos = (BlockPos)stack.get(DataComponentRegistry.position);
                    player.changeDimension(new DimensionTransition(serverWorld, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(0.5, 0.0, 0.5), player.getDeltaMovement(), player.getYRot(), player.getXRot(), false, DimensionTransition.PLAY_PORTAL_SOUND));
                    if (!player.isCreative()) {
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                    player.getCooldowns().addCooldown((Item)this, 160);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    return InteractionResultHolder.success((Object)stack);
                }
            } else {
                Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "teleport.no_position", new Object[0]);
                player.displayClientMessage(message, true);
                return InteractionResultHolder.fail((Object)stack);
            }
        }
        return super.use(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(DataComponentRegistry.dimension)) {
            tooltip.add(LocalizeUtils.i18n(ChatFormatting.WHITE, "teleport.dimension", ((ResourceLocation)stack.get(DataComponentRegistry.dimension)).toString()));
        }
        if (stack.has(DataComponentRegistry.position)) {
            BlockPos pos = (BlockPos)stack.get(DataComponentRegistry.position);
            tooltip.add(LocalizeUtils.i18n(ChatFormatting.WHITE, "teleport.block_position", pos.getX(), pos.getY(), pos.getZ()));
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        itemEntity.level().playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.ENDER_EYE_DEATH, SoundSource.NEUTRAL);
    }
}

