/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.items.base.ItemMod;
import divinerpg.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemArmorPouch
extends ItemMod {
    public ItemArmorPouch(int nameColor) {
        super(new Item.Properties().stacksTo(1));
        this.nameColor = nameColor;
    }

    public boolean isFoil(ItemStack item) {
        return item.isEnchanted() || item.has(DataComponents.CONTAINER);
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        ItemStack item = entity.getItem();
        if (item.has(DataComponents.CONTAINER)) {
            ItemContainerContents container = (ItemContainerContents)item.get(DataComponents.CONTAINER);
            Utils.drop(entity.level(), entity.position(), container.getStackInSlot(0));
            Utils.drop(entity.level(), entity.position(), container.getStackInSlot(1));
            Utils.drop(entity.level(), entity.position(), container.getStackInSlot(2));
            Utils.drop(entity.level(), entity.position(), container.getStackInSlot(3));
        }
    }

    public boolean onLeftClickEntity(ItemStack itemstack, Player player, Entity entity) {
        if (itemstack.is((Item)this) && entity instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)entity;
            HolderLookup.RegistryLookup enchantmentRegistry = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            List<ItemStack> container = itemstack.has(DataComponents.CONTAINER) ? ItemArmorPouch.getContainerContentsAsList((ItemContainerContents)itemstack.get(DataComponents.CONTAINER)) : this.createEmptyContainer();
            ItemStack stack = stand.getItemBySlot(EquipmentSlot.HEAD);
            if (!Utils.hasEnchantment(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
                this.setEntitySlot((LivingEntity)stand, EquipmentSlot.HEAD, container.getFirst());
                this.setContainerSlot(container, 0, stack);
            }
            if (!Utils.hasEnchantment(stack = stand.getItemBySlot(EquipmentSlot.CHEST), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
                this.setEntitySlot((LivingEntity)stand, EquipmentSlot.CHEST, container.get(1));
                this.setContainerSlot(container, 1, stack);
            }
            if (!Utils.hasEnchantment(stack = stand.getItemBySlot(EquipmentSlot.LEGS), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
                this.setEntitySlot((LivingEntity)stand, EquipmentSlot.LEGS, container.get(2));
                this.setContainerSlot(container, 2, stack);
            }
            if (!Utils.hasEnchantment(stack = stand.getItemBySlot(EquipmentSlot.FEET), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
                this.setEntitySlot((LivingEntity)stand, EquipmentSlot.FEET, container.get(3));
                this.setContainerSlot(container, 3, stack);
            }
            if (ItemArmorPouch.isEmptyItemList(container)) {
                itemstack.remove(DataComponents.CONTAINER);
            } else {
                itemstack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(container));
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
            player.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value());
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return true;
        }
        return super.onLeftClickEntity(itemstack, player, entity);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!itemstack.is((Item)this)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        HolderLookup.RegistryLookup enchantmentRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        List<ItemStack> container = itemstack.has(DataComponents.CONTAINER) ? ItemArmorPouch.getContainerContentsAsList((ItemContainerContents)itemstack.get(DataComponents.CONTAINER)) : this.createEmptyContainer();
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!Utils.hasEnchantment(stack, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
            this.setEntitySlot((LivingEntity)player, EquipmentSlot.HEAD, container.getFirst());
            this.setContainerSlot(container, 0, stack);
        }
        if (!Utils.hasEnchantment(stack = player.getItemBySlot(EquipmentSlot.CHEST), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
            this.setEntitySlot((LivingEntity)player, EquipmentSlot.CHEST, container.get(1));
            this.setContainerSlot(container, 1, stack);
        }
        if (!Utils.hasEnchantment(stack = player.getItemBySlot(EquipmentSlot.LEGS), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
            this.setEntitySlot((LivingEntity)player, EquipmentSlot.LEGS, container.get(2));
            this.setContainerSlot(container, 2, stack);
        }
        if (!Utils.hasEnchantment(stack = player.getItemBySlot(EquipmentSlot.FEET), (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistry, (ResourceKey<Enchantment>)Enchantments.BINDING_CURSE)) {
            this.setEntitySlot((LivingEntity)player, EquipmentSlot.FEET, container.get(3));
            this.setContainerSlot(container, 3, stack);
        }
        if (ItemArmorPouch.isEmptyItemList(container)) {
            itemstack.remove(DataComponents.CONTAINER);
        } else {
            itemstack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(container));
        }
        player.setItemInHand(hand, itemstack);
        player.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value());
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.success((Object)itemstack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(DataComponents.CONTAINER)) {
            ItemContainerContents container = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            ItemStack helmet = container.getStackInSlot(0);
            ItemStack chestplate = container.getStackInSlot(1);
            ItemStack leggings = container.getStackInSlot(2);
            ItemStack boots = container.getStackInSlot(3);
            if (!ItemArmorPouch.isEmpty(helmet)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.divinerpg.armor_pouch.helmet").append(helmet.getHoverName()).withStyle(ChatFormatting.WHITE));
            }
            if (!ItemArmorPouch.isEmpty(chestplate)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.divinerpg.armor_pouch.chestplate").append(chestplate.getHoverName()).withStyle(ChatFormatting.WHITE));
            }
            if (!ItemArmorPouch.isEmpty(leggings)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.divinerpg.armor_pouch.leggings").append(leggings.getHoverName()).withStyle(ChatFormatting.WHITE));
            }
            if (!ItemArmorPouch.isEmpty(boots)) {
                tooltip.add((Component)Component.translatable((String)"tooltip.divinerpg.armor_pouch.boots").append(boots.getHoverName()).withStyle(ChatFormatting.WHITE));
            }
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public void setEntitySlot(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        entity.setItemSlot(slot, stack.getItem() instanceof ItemArmorPouch ? ItemStack.EMPTY : stack);
    }

    public void setContainerSlot(List<ItemStack> container, int slot, ItemStack stack) {
        container.set(slot, stack.isEmpty() ? this.getDefaultInstance() : stack);
    }

    public static boolean isEmpty(ItemStack i) {
        return i.isEmpty() || i.getItem() instanceof ItemArmorPouch;
    }

    public static List<ItemStack> getContainerContentsAsList(ItemContainerContents c) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < c.getSlots(); ++i) {
            result.add(c.getStackInSlot(i));
        }
        if (result.size() != 4) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static boolean isEmptyItemList(List<ItemStack> list) {
        for (ItemStack i : list) {
            if (ItemArmorPouch.isEmpty(i)) continue;
            return false;
        }
        return true;
    }

    private List<ItemStack> createEmptyContainer() {
        return new ArrayList<ItemStack>(List.of(this.getDefaultInstance(), this.getDefaultInstance(), this.getDefaultInstance(), this.getDefaultInstance()));
    }
}

