/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.staffs;

import divinerpg.entities.projectile.magic.EntityBouncingProjectile;
import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VetheanStaff
extends ItemRangedWeapon {
    float damage;

    public VetheanStaff(int arcanaUse, float damage) {
        super(() -> EntityRegistry.BOUNCING_PROJECTILE.value());
        this.arcanaConsumedUse = arcanaUse;
        this.damage = damage;
        this.sound = (SoundEvent)SoundRegistry.STAFF.get();
        this.tooltips.add(LocalizeUtils.arcanaDam((int)(damage * 3.0f)));
        this.tooltips.add(LocalizeUtils.bouncingShots());
    }

    protected VetheanStaff(Supplier<EntityType<? extends Projectile>> projectileType, int arcanaUse, float damage) {
        super(projectileType);
        this.arcanaConsumedUse = arcanaUse;
        this.damage = damage;
        this.sound = (SoundEvent)SoundRegistry.STAFF.get();
        this.tooltips.add(LocalizeUtils.arcanaDam((int)(damage * 3.0f)));
        this.tooltips.add(LocalizeUtils.bouncingShots());
    }

    protected EntityBouncingProjectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        EntityBouncingProjectile p = (EntityBouncingProjectile)super.createProjectile(level, shooter, weapon, ammo, isCrit);
        p.baseDamage = this.damage;
        return p;
    }
}

