/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.staffs;

import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SkyDropStaff
extends ItemRangedWeapon {
    public final int projectileCount;
    public final int damage;

    public SkyDropStaff(Supplier<EntityType<? extends Projectile>> projectileType, int arcana, int damage, int count, int delay, int uses) {
        super(projectileType, uses);
        this.sound = (SoundEvent)SoundRegistry.STARLIGHT.get();
        this.cooldown = delay;
        this.arcanaConsumedUse = arcana;
        this.damage = damage;
        this.projectileCount = count;
        this.withTooltip(LocalizeUtils.arcanaDam(damage)).withTooltip(LocalizeUtils.skyShots(count));
    }

    @Override
    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        for (int i = 0; i < this.projectileCount; ++i) {
            super.shoot(level, shooter, hand, weapon, projectileItems, velocity, inaccuracy, isCrit, target);
        }
    }

    @Override
    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int i, float velocity, float inaccuracy, float angle, @Nullable LivingEntity livingEntity1) {
        int blockReachDistance = 32;
        Vec3 vec3d = shooter.getEyePosition(1.0f);
        Vec3 vec3d1 = shooter.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * (double)blockReachDistance, vec3d1.y * (double)blockReachDistance, vec3d1.z * (double)blockReachDistance);
        BlockHitResult pos = shooter.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)shooter));
        projectile.moveTo((double)pos.getBlockPos().getX() + shooter.getRandom().nextDouble() - 0.5, (double)(pos.getBlockPos().getY() + 20), (double)pos.getBlockPos().getZ() + shooter.getRandom().nextDouble() - 0.5);
    }
}

