/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.bows;

import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.RarityList;
import divinerpg.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class InfernoBow
extends ItemBow {
    public InfernoBow() {
        super(new Item.Properties().fireResistant(), 0, 72000, 1.0f, (Supplier<Item>)ItemRegistry.inferno_arrow, RarityList.INFERNO);
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.igniteForTicks(0x3FFFFFFF);
        return arrow;
    }

    @Override
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return new ItemStack((ItemLike)ItemRegistry.inferno_arrow.get());
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) && !enchantment.is(Enchantments.FLAME);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book) && !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.FLAME, book);
    }
}

