/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged;

import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.items.vanilla.ItemTomato;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemThrowable
extends ItemRangedWeapon
implements ProjectileItem {
    public final float damage;

    public ItemThrowable(float damage) {
        this(() -> EntityRegistry.THROWN_ITEM.value(), damage);
        this.power = 2.0f;
        this.infinite = false;
    }

    public ItemThrowable(Supplier<EntityType<? extends Projectile>> projectileType, float damage) {
        super(new Item.Properties().stacksTo(32), projectileType);
        this.damage = damage;
        this.power = 2.0f;
        this.infinite = false;
    }

    public ItemThrowable(Item.Properties properties, Supplier<EntityType<? extends Projectile>> projectileType, float damage) {
        super(properties, projectileType);
        this.damage = damage;
        this.power = 2.0f;
        this.infinite = false;
    }

    @Override
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return projectileWeaponItem;
    }

    protected DivineThrownItem createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Player player;
        DivineThrownItem projectile = (DivineThrownItem)super.createProjectile(level, shooter, weapon, ammo, isCrit);
        projectile.setItem(weapon);
        projectile.setPos(shooter.getEyePosition());
        if (shooter instanceof Player && (player = (Player)shooter).isCreative()) {
            projectile.canPickup = false;
        }
        return projectile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (!(this instanceof ItemTomato)) {
            tooltip.add(LocalizeUtils.rangedDam((int)(this.damage * 2.0f)));
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        DivineThrownItem projectile = (DivineThrownItem)((EntityType)this.projectileType.get()).create(level);
        projectile.setItem(itemStack);
        projectile.setPos(new Vec3(position.x(), position.y(), position.z()));
        return projectile;
    }
}

