/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.iceika;

import divinerpg.blocks.base.PortalBlock;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemSnowGlobe
extends ItemMod {
    public ItemSnowGlobe() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level worldIn = context.getLevel();
        Player player = context.getPlayer();
        if (!player.mayUseItemAt(pos, facing, player.getItemInHand(context.getHand()))) {
            return InteractionResult.FAIL;
        }
        BlockState block = worldIn.getBlockState(pos);
        if (!block.is(BlockRegistry.icyFire)) {
            return InteractionResult.FAIL;
        }
        if (!worldIn.isClientSide()) {
            PortalBlock portal = (PortalBlock)((Object)BlockRegistry.iceikaPortal.get());
            worldIn.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
            Direction.Axis axis = portal.checkForFrame(worldIn, pos);
            if (axis != null) {
                PortalBlock.spreadBlock(worldIn, (BlockState)portal.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis), pos, Blocks.AIR, axis);
                worldIn.playSound(null, pos, (SoundEvent)SoundRegistry.ICEIKA_PORTAL_TRIGGER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            worldIn.setBlock(pos, block, 4);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("snow_globe", new Object[0]));
    }
}

