/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.iceika;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemHeatPack
extends ItemMod {
    public ItemHeatPack() {
        super(new Item.Properties().durability(1000));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean b) {
        if (ItemHeatPack.isActivated(stack)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living.getTicksFrozen() > 2) {
                    living.setTicksFrozen(living.getTicksFrozen() - 3);
                }
                stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)living.getUsedItemHand()));
            } else {
                stack.setDamageValue(stack.getDamageValue() + 1);
                if (stack.getDamageValue() >= stack.getMaxDamage()) {
                    stack.setCount(0);
                }
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return ItemHeatPack.isActivated(stack);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!ItemHeatPack.isActivated(stack)) {
            stack.set(DataComponentRegistry.activated, (Object)true);
            player.playSound((SoundEvent)SoundRegistry.SNAP.get());
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private static boolean isActivated(ItemStack stack) {
        return stack.has(DataComponentRegistry.activated) && (Boolean)stack.get(DataComponentRegistry.activated) != false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (ItemHeatPack.isActivated(stack)) {
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (stack.getDamageValue() >= stack.getMaxDamage()) {
                entity.kill();
            }
        }
        return false;
    }
}

