/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.util.LocalizeUtils;
import divinerpg.util.Utils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemModPickaxe
extends PickaxeItem {
    public Integer nameColor;

    public ItemModPickaxe(Tier tier, Item.Properties properties) {
        super(tier, (tier.getUses() == 0 ? properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : properties).attributes(PickaxeItem.createAttributes((Tier)tier, (float)0.0f, (float)-2.8f)));
    }

    public ItemModPickaxe(Tier tier) {
        this(tier, new Item.Properties());
    }

    public ItemModPickaxe(Tier tier, int rarity) {
        this(tier, new Item.Properties());
        this.nameColor = rarity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.efficiency((int)this.getTier().getSpeed()));
        TagKey tagKey = this.getTier().getIncorrectBlocksForDrops();
        if (tagKey == BlockTags.INCORRECT_FOR_DIAMOND_TOOL || tagKey == BlockTags.INCORRECT_FOR_NETHERITE_TOOL) {
            tooltip.add(LocalizeUtils.harvestLevel(Items.OBSIDIAN.asItem().getName(stack)));
        } else if (tagKey == BlockTags.INCORRECT_FOR_IRON_TOOL) {
            tooltip.add(LocalizeUtils.harvestLevel(Items.DIAMOND.getName(stack)));
        }
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) && (!stack.has(DataComponents.UNBREAKABLE) || !enchantment.is(Enchantments.MENDING) && !enchantment.is(Enchantments.UNBREAKING));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !stack.has(DataComponents.UNBREAKABLE) || !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, book) && !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, book);
    }
}

