/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.RarityList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ItemBossSpawner
extends ItemMod {
    private final Supplier<EntityType<?>> ent;
    private final String langKey;
    public ResourceKey<Level> dimensionID;

    public ItemBossSpawner(String key, ResourceKey<Level> dimension, Supplier<EntityType<?>> entity) {
        super(new Item.Properties().stacksTo(1));
        this.dimensionID = dimension;
        this.ent = entity;
        this.langKey = key;
        this.nameColor = RarityList.RED;
    }

    public ItemBossSpawner(String key, ResourceKey<Level> dimension) {
        super(new Item.Properties().stacksTo(1));
        this.dimensionID = dimension;
        this.langKey = key;
        this.ent = null;
        this.nameColor = RarityList.RED;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockPos pos1 = world.getBlockState(pos = context.getClickedPos()).getCollisionShape((BlockGetter)world, pos).isEmpty() ? pos : pos.relative(context.getClickedFace());
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        if (this.dimensionID == null) {
            this.dimensionID = LevelRegistry.MORTUM;
        }
        if (world.dimension() != this.dimensionID) {
            player.displayClientMessage(LocalizeUtils.clientMessage(ChatFormatting.AQUA, this.langKey, new Object[0]), true);
            return InteractionResult.FAIL;
        }
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            player.displayClientMessage(LocalizeUtils.clientMessage(ChatFormatting.AQUA, "boss.peaceful", new Object[0]), true);
            return InteractionResult.FAIL;
        }
        if (world.getBlockStates(this.ent.get().getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY() + 2.14, (double)pos.getZ() + 0.5).inflate(1.0)).allMatch(BlockBehaviour.BlockStateBase::isAir)) {
            if (!world.isClientSide && this.ent != null) {
                this.ent.get().spawn((ServerLevel)world, player.getItemInHand(hand), player, pos1, MobSpawnType.MOB_SUMMONED, true, false);
            }
            player.getItemInHand(hand).consume(1, (LivingEntity)player);
            player.getCooldowns().addCooldown((Item)this, 40);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage(LocalizeUtils.clientMessage(ChatFormatting.AQUA, "boss.space", new Object[0]), true);
        return InteractionResult.FAIL;
    }
}

