/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.client.renders.item.DivineShieldRenderer;
import divinerpg.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class DivineShield
extends ShieldItem {
    public ResourceLocation resource;
    public Integer nameColor;
    private final Ingredient repairMaterial;

    public DivineShield(int nameColor, Item repairMaterial, int damage, String name) {
        super(damage == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties().durability(damage));
        this.repairMaterial = Ingredient.of((ItemLike[])new ItemLike[]{repairMaterial});
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.resource = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/shield/" + name + ".png"));
        this.nameColor = nameColor;
    }

    public DivineShield(Item repairMaterial, int damage, String name) {
        super(damage == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties().durability(damage));
        this.repairMaterial = Ingredient.of((ItemLike[])new ItemLike[]{repairMaterial});
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.resource = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/shield/" + name + ".png"));
    }

    public boolean isValidRepairItem(ItemStack shield, ItemStack repairItem) {
        if (this.repairMaterial != null) {
            return this.repairMaterial.test(repairItem);
        }
        return super.isValidRepairItem(shield, repairItem);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderProps.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) && (!stack.has(DataComponents.UNBREAKABLE) || !enchantment.is(Enchantments.MENDING) && !enchantment.is(Enchantments.UNBREAKING));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !stack.has(DataComponents.UNBREAKABLE) || !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.MENDING, book) && !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.UNBREAKING, book);
    }

    static class RenderProps
    implements IClientItemExtensions {
        public static RenderProps INSTANCE = new RenderProps();

        RenderProps() {
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return new DivineShieldRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
    }
}

