/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.attachments.Arcana;
import divinerpg.items.base.ItemModFood;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemArcanaPotion
extends ItemModFood {
    protected int amountToAdd;

    public ItemArcanaPotion(FoodProperties list, int amountToAdd) {
        super(new Item.Properties().food(list));
        this.amountToAdd = amountToAdd;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!worldIn.isClientSide()) {
            if (Arcana.hasArcana(entityLiving)) {
                Arcana.modifyAmount(entityLiving, this.amountToAdd);
            }
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entityLiving;
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                stack.consume(1, (LivingEntity)player);
            }
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.arcanaRegen(this.amountToAdd));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

