/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchant;

import divinerpg.registries.EnchantmentRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="divinerpg")
public class BrainFreezeHandler {
    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getSource().getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        int level = EnchantmentHelper.getEnchantmentLevel((Holder)entity.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.BRAIN_FREEZE), (LivingEntity)livingEntity);
        if (level < 1) {
            return;
        }
        if (livingEntity.getRandom().nextInt(100) > 30 - level * 5) {
            return;
        }
        event.getEntity().addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20 * level, 10, true, false, false));
    }
}

