/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.attachments.DimensionalInventory;
import divinerpg.config.CommonConfig;
import divinerpg.events.ArmorAbilitiesEvent;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.LevelRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class VetheaInventorySwapEvent {
    public static final String OVERWORLD_INVENTORY = "drpg_regular_inventory";
    public static final String VETHEA_INVENTORY = "drpg_dream_inventory";

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        AttachmentRegistry.GROGLIN_REPUTATION.clone((Entity)original, (Entity)clone);
        AttachmentRegistry.GRUZZORLUG_REPUTATION.clone((Entity)original, (Entity)clone);
        AttachmentRegistry.ICEIKA_MERCHANT_REPUTATION.clone((Entity)original, (Entity)clone);
        AttachmentRegistry.DIMENSIONAL_INVENTORY.clone((Entity)original, (Entity)clone);
        AttachmentRegistry.MAX_ARCANA.clone((Entity)original, (Entity)clone);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!CommonConfig.Values.SAFER_VETHEA) {
                DimensionalInventory d = AttachmentRegistry.DIMENSIONAL_INVENTORY.get((Entity)player);
                if (player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                    if (player.level().dimension().equals(LevelRegistry.VETHEA)) {
                        d.saveInventory(player, VETHEA_INVENTORY);
                    } else {
                        d.saveInventory(player, OVERWORLD_INVENTORY);
                    }
                } else if (player.level().dimension().equals(LevelRegistry.VETHEA)) {
                    d.clearInventory(VETHEA_INVENTORY);
                } else {
                    d.clearInventory(OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((ResourceKey<Level>)player.level().dimension(), (LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!CommonConfig.Values.SAFER_VETHEA && !event.isEndConquered()) {
            DimensionalInventory d = AttachmentRegistry.DIMENSIONAL_INVENTORY.get((Entity)player);
            if (player.level().dimension().equals(LevelRegistry.VETHEA)) {
                d.loadInventory(player, VETHEA_INVENTORY);
            } else {
                d.loadInventory(player, OVERWORLD_INVENTORY);
            }
            player.inventoryMenu.broadcastChanges();
        }
        ArmorAbilitiesEvent.updateAbilities((ResourceKey<Level>)player.level().dimension(), (LivingEntity)player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onDimensionChange(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (!event.isCanceled() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            if (!CommonConfig.Values.SAFER_VETHEA) {
                boolean from = player.level().dimension().equals(LevelRegistry.VETHEA);
                boolean to = event.getDimension().equals(LevelRegistry.VETHEA);
                DimensionalInventory d = AttachmentRegistry.DIMENSIONAL_INVENTORY.get((Entity)player);
                if (from ^ to) {
                    if (from) {
                        d.saveInventory(player, VETHEA_INVENTORY);
                        d.loadInventory(player, OVERWORLD_INVENTORY);
                    } else {
                        d.saveInventory(player, OVERWORLD_INVENTORY);
                        d.loadInventory(player, VETHEA_INVENTORY);
                    }
                    player.removeAllEffects();
                } else if (from && to) {
                    d.saveInventory(player, VETHEA_INVENTORY);
                } else {
                    d.saveInventory(player, OVERWORLD_INVENTORY);
                }
            }
            ArmorAbilitiesEvent.updateAbilities((ResourceKey<Level>)event.getDimension(), (LivingEntity)player);
        }
    }
}

