/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityLorga
extends EntityDivineMonster {
    public boolean canSpawnMinions;

    public EntityLorga(EntityType<? extends EntityLorga> type, Level worldIn) {
        this(type, worldIn, true);
    }

    public EntityLorga(EntityType<? extends EntityLorga> type, Level worldIn, boolean canSpawnMinions) {
        super(type, worldIn);
        this.canSpawnMinions = canSpawnMinions;
    }

    public int getMaxSpawnClusterSize() {
        return 8;
    }

    public boolean isMaxGroupSizeReached(int i) {
        return i < 8;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.canSpawnMinions && this.getRandom().nextInt(64) == 0 && this.level().getEntities(null, new AABB(-10.0, -3.0, -10.0, 10.0, 3.0, 10.0)).size() < 8) {
            BlockPos pos = this.blockPosition().offset(this.random.nextInt(5) - 2, 0, this.random.nextInt(5) - 2);
            if (this.level().getBlockState(pos).isAir() && this.level().getBlockState(pos.above()).isAir()) {
                ((EntityLorga)((EntityType)EntityRegistry.LORGA.get()).spawn((ServerLevel)((ServerLevel)this.level()), (ItemStack)ItemStack.EMPTY, null, (BlockPos)pos, (MobSpawnType)MobSpawnType.MOB_SUMMONED, (boolean)false, (boolean)false)).canSpawnMinions = false;
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("CanSpawnMinions", this.canSpawnMinions);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.canSpawnMinions = tag.getBoolean("CanSpawnMinions");
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.LORGA.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.LORGA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.LORGA_HURT.get();
    }
}

