/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineTameable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class EntitySnapper
extends EntityDivineTameable {
    public EntitySnapper(EntityType<? extends EntitySnapper> type, Level worldIn) {
        super(type, worldIn, 1.0f);
    }

    @Override
    public boolean isFood(ItemStack item) {
        return item.is(ItemTags.FISHES) || item.is(Items.KELP) || item.is(Items.SEAGRASS);
    }

    @Override
    protected boolean isTamingFood(ItemStack item) {
        return item.is(Tags.Items.SLIME_BALLS);
    }

    public void tick() {
        super.tick();
        if (this.getOwner() != null && this.getOwner() instanceof Player && this.random.nextInt(3000) == 0) {
            this.getOwner().addEffect(new MobEffectInstance(MobEffects.SATURATION, 120));
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.TURTLE_AMBIENT_LAND;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.TURTLE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.TURTLE_DEATH;
    }
}

