/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.bullet.EntitySaguaroWormShot;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.Tags;

public class EntitySaguaroWorm
extends EntityDivineMonster
implements RangedAttackMob {
    public EntitySaguaroWorm(EntityType<? extends EntitySaguaroWorm> type, Level worldIn) {
        super(type, worldIn);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.setRot(0.0f, 0.0f);
        this.absRotateTo(0.0f, 0.0f);
        this.setYBodyRot(0.0f);
        this.setYHeadRot(0.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 30, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
    }

    public static boolean saguaroWormSpawnRule(LevelAccessor worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).is(Tags.Blocks.SANDS);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Player player = this.level().getNearestPlayer((Entity)this, 6.0);
            if (player != null && this.hasLineOfSight((Entity)player)) {
                this.setProvoked((LivingEntity)player);
            } else {
                this.setProvoked(this.getTarget());
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            entity = source.getEntity();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity;
            if (!l.level().isClientSide) {
                this.setProvoked(l);
            }
        }
        return super.hurt(source, amount);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean getProvoked() {
        return (Boolean)AttachmentRegistry.ANGRY.get((Entity)this);
    }

    public void setProvoked(LivingEntity entity) {
        if (entity == null || !this.hasLineOfSight((Entity)entity) && entity.distanceTo((Entity)this) > (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue() || !entity.isAlive()) {
            if (this.getProvoked()) {
                this.calmDown();
            }
        } else {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
                if (this.getProvoked()) {
                    this.calmDown();
                }
                return;
            }
            AttachmentRegistry.ANGRY.set((Entity)this, true);
            this.setTarget(entity);
        }
    }

    public void calmDown() {
        this.setTarget(null);
        AttachmentRegistry.ANGRY.set((Entity)this, false);
        this.setRot(0.0f, 0.0f);
        this.absRotateTo(0.0f, 0.0f);
        this.setYBodyRot(0.0f);
        this.setYHeadRot(0.0f);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide && target.distanceTo((Entity)this) <= (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()) {
            for (int i = 0; i < 20; ++i) {
                EntitySaguaroWormShot shot = (EntitySaguaroWormShot)((EntityType)EntityRegistry.SAGUARO_WORM_SHOT.get()).create(this.level());
                shot.setOwner((Entity)this);
                shot.setPos(this.getEyePosition());
                double d0 = this.getTarget().getX() - this.getX();
                double d1 = this.getTarget().getY(0.3333333333333333) - shot.getY();
                double d2 = this.getTarget().getZ() - this.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                shot.shoot(d0, d1 + d3 * 0.2, d2, 0.9f, 10.0f);
                this.level().addFreshEntity((Entity)shot);
            }
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.SAGUARO_WORM.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.SAGUARO_WORM.get();
    }
}

