/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.registries.AttachmentRegistry;
import javax.annotation.Nullable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;

public class EntityPumpkinSpider
extends Spider {
    public EntityPumpkinSpider(EntityType<? extends Spider> type, Level worldIn) {
        super(type, worldIn);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide) {
            AttachmentRegistry.ANGRY.requestAttachment((Entity)this, null);
        }
        this.setRot(0.0f, 0.0f);
        this.absRotateTo(0.0f, 0.0f);
        this.setYBodyRot(0.0f);
        this.setYHeadRot(0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, this.getProvoked()));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Player player = this.level().getNearestPlayer((Entity)this, 4.0);
            if (player != null && this.hasLineOfSight((Entity)player)) {
                this.setProvoked((LivingEntity)player);
            } else {
                this.setProvoked(this.getTarget());
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            entity = source.getEntity();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity l = (LivingEntity)entity;
            if (!l.level().isClientSide) {
                this.setProvoked(l);
            }
        }
        return super.hurt(source, amount);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data) {
        return data;
    }

    public boolean getProvoked() {
        return (Boolean)AttachmentRegistry.ANGRY.get((Entity)this);
    }

    public void setProvoked(LivingEntity entity) {
        if (entity == null || !this.hasLineOfSight((Entity)entity) && entity.distanceTo((Entity)this) > (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue() || !entity.isAlive()) {
            if (this.getProvoked()) {
                this.calmDown();
            }
        } else {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
                if (this.getProvoked()) {
                    this.calmDown();
                }
                return;
            }
            AttachmentRegistry.ANGRY.set((Entity)this, true);
            this.setTarget(entity);
        }
    }

    public void calmDown() {
        this.setTarget(null);
        AttachmentRegistry.ANGRY.set((Entity)this, false);
        this.getNavigation().setSpeedModifier(0.0);
        this.setRot(0.0f, 0.0f);
        this.absRotateTo(0.0f, 0.0f);
        this.setYBodyRot(0.0f);
        this.setYHeadRot(0.0f);
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType type) {
        return !level.getBiome(this.blockPosition()).is(Tags.Biomes.IS_MUSHROOM) && !level.getBiome(this.blockPosition()).is(Biomes.DEEP_DARK);
    }
}

