/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.goals.miner.FindOreGoal;
import divinerpg.entities.goals.miner.MoveToChestGoal;
import divinerpg.entities.goals.miner.MoveToItemGoal;
import divinerpg.entities.goals.miner.StoreInChestGoal;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class EntityMiner
extends EntityDivineMonster {
    private static final Predicate<Difficulty> HARD_DIFFICULTY_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final Container inventory = new SimpleContainer(36){

        public boolean isEmpty() {
            for (int i = 0; i < EntityMiner.this.inventory.getContainerSize(); ++i) {
                if (EntityMiner.this.inventory.getItem(i).isEmpty()) continue;
                return false;
            }
            return true;
        }
    };
    private final Random random = new Random();

    public EntityMiner(EntityType<? extends EntityMiner> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new BreakDoorGoal((Mob)this, HARD_DIFFICULTY_PREDICATE));
        this.goalSelector.addGoal(3, (Goal)new FindOreGoal(this, 1.0, null));
        this.goalSelector.addGoal(4, (Goal)new MoveToChestGoal(this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new MoveToItemGoal(this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new StoreInChestGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 100));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    public boolean doHurtTarget(Entity entityIn) {
        boolean flag = super.doHurtTarget(entityIn);
        if (flag) {
            float f = this.level().getDifficulty().getId();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < f * 0.3f) {
                entityIn.setRemainingFireTicks(2 * (int)f);
            }
        }
        return flag;
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        if (this.random.nextInt(7) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        } else if (this.random.nextInt(5) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_PICKAXE));
        } else if (this.random.nextInt(3) == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_PICKAXE));
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_PICKAXE));
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive()) {
            boolean flag;
            if (!this.level().isClientSide) {
                for (ItemEntity itemEntity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(16.0))) {
                    if (itemEntity == null || !((double)this.distanceTo((Entity)itemEntity) < 16.0)) continue;
                    this.navigation.moveTo((Entity)itemEntity, 1.0);
                    if (itemEntity == null || !((double)this.distanceTo((Entity)itemEntity) < 1.5)) continue;
                    this.pickUpDroppedItem(itemEntity);
                }
            }
            if (flag = this.isSunBurnTick()) {
                ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
                if (!itemstack.isEmpty()) {
                    if (itemstack.isDamageableItem()) {
                        Item item = itemstack.getItem();
                        itemstack.setDamageValue(itemstack.getDamageValue() + this.random.nextInt(2));
                        if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                            this.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.igniteForSeconds(8.0f);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.populateDefaultEquipmentSlots(this.getRandom(), difficultyIn);
        this.populateDefaultEquipmentEnchantments(level, this.getRandom(), difficultyIn);
        return spawnDataIn;
    }

    public boolean addItemToInventory(ItemStack stack) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack existingStack = this.inventory.getItem(i);
            if (!existingStack.isEmpty() && (!existingStack.is(stack.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize())) continue;
            this.inventory.setItem(i, stack.copy());
            return true;
        }
        return false;
    }

    public void pickUpDroppedItem(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.getItem();
        if (!stack.isEmpty()) {
            if (!this.addItemToInventory(stack)) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
            } else {
                itemEntity.discard();
            }
        }
    }

    public void onItemPickup(ItemEntity itemEntity) {
        if (this.isAlive()) {
            this.pickUpDroppedItem(itemEntity);
        }
    }

    public Container getInventory() {
        return this.inventory;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
            this.level().addFreshEntity((Entity)itemEntity);
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
    }
}

