/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityLivestockMerchant
extends EntityDivineMerchant {
    public EntityLivestockMerchant(EntityType<? extends EntityDivineMerchant> type, Level worldIn) {
        super(type, worldIn, "livestock_merchant");
    }

    @Override
    public String[] getChatMessages() {
        return new String[]{"message.livestock.hi", "message.livestock.sell", "message.livestock.snapper", "message.livestock.travel"};
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.LIVESTOCK_MERCHANT.get(this.level(), this.getRandom()), 5);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.LIVESTOCK_MERCHANT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.LIVESTOCK_MERCHANT_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.LIVESTOCK_MERCHANT_HURT.get();
    }
}

