/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EntityKobblin
extends EntityDivineMonster
implements RangedAttackMob {
    public int clientBiomeColor = 65280;
    boolean prefersShooting;

    public EntityKobblin(EntityType<? extends EntityKobblin> type, Level worldIn) {
        super(type, worldIn);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.prefersShooting = this.getRandom().nextBoolean();
        if (this.level().isClientSide) {
            this.clientBiomeColor = ((Biome)this.level().getBiome(this.blockPosition()).value()).getGrassColor(this.getX(), this.getZ());
        }
    }

    public static boolean kobblinSpawnRule(LevelAccessor worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).is(BlockTags.DIRT);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean canUse() {
                return !EntityKobblin.this.prefersShooting && super.canUse() && !EntityKobblin.this.isEmerging();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && !EntityKobblin.this.isEmerging();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new KobblinRangedAttackGoal(1.25, 40, 60, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                return super.canUse() && !EntityKobblin.this.isEmerging();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean canUse() {
                return super.canUse() && !EntityKobblin.this.isEmerging();
            }
        });
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, this.getPose().id());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (packet.getData() == 0) {
            this.setPose(Pose.STANDING);
        } else if (packet.getData() == 13) {
            this.setPose(Pose.EMERGING);
        } else if (packet.getData() == 16) {
            this.setPose(Pose.SHOOTING);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isEmerging() || super.isInvulnerableTo(source);
    }

    boolean isEmerging() {
        return this.hasPose(Pose.EMERGING);
    }

    public void tick() {
        super.tick();
        if (this.hasPose(Pose.EMERGING)) {
            if (this.level().isClientSide) {
                this.clientDiggingParticles();
                if ((this.tickCount & 3) == 0) {
                    this.level().playLocalSound((Entity)this, SoundEvents.ROOTED_DIRT_PLACE, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
            if (this.tickCount > 20) {
                this.setPose(Pose.STANDING);
            }
        }
    }

    private void clientDiggingParticles() {
        RandomSource randomsource = this.getRandom();
        BlockState blockstate = this.getBlockStateOn();
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 8; ++i) {
                double dx = this.getX() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.3f, (float)0.3f);
                double dy = this.getY();
                double dz = this.getZ() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.3f, (float)0.3f);
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), dx, dy, dz, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return this.isEmerging();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.TRIGGERED && level.getBlockState(this.getOnPos()).is(BlockTags.DIRT)) {
            this.setPose(Pose.EMERGING);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions entitydimensions = super.getDefaultDimensions(pose);
        return this.isEmerging() ? EntityDimensions.fixed((float)entitydimensions.width(), (float)1.0f) : entitydimensions;
    }

    public boolean isPushable() {
        return !this.isEmerging() && super.isPushable();
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            DivineThrownItem shot = (DivineThrownItem)((EntityType)EntityRegistry.THROWN_ITEM.get()).create(this.level());
            shot.setItem(Blocks.COARSE_DIRT.asItem().getDefaultInstance());
            shot.setOwner((Entity)this);
            shot.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - shot.getY() - 0.25;
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            shot.shoot(d0, d1 + d3 * 0.18, d2, 1.6f, 0.5f);
            this.level().addFreshEntity((Entity)shot);
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.KOBBLIN.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.KOBBLIN.get();
    }

    class KobblinRangedAttackGoal
    extends Goal {
        final double speedModifier;
        final int attackIntervalMin;
        final int attackIntervalMax;
        final float attackRadius;
        final float attackRadiusSqr;
        int attackTime;
        int seeTime;
        LivingEntity target;

        public KobblinRangedAttackGoal(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius) {
            this.speedModifier = speedModifier;
            this.attackIntervalMin = attackIntervalMin;
            this.attackIntervalMax = attackIntervalMax;
            this.attackRadius = attackRadius;
            this.attackRadiusSqr = attackRadius * attackRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = EntityKobblin.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                this.target = livingentity;
                return EntityKobblin.this.prefersShooting && !EntityKobblin.this.isEmerging();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse() || this.target.isAlive() && !EntityKobblin.this.getNavigation().isDone();
        }

        public void stop() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            if (EntityKobblin.this.hasPose(Pose.SHOOTING)) {
                EntityKobblin.this.setPose(Pose.STANDING);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            double d0 = EntityKobblin.this.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
            boolean hasSight = EntityKobblin.this.getSensing().hasLineOfSight((Entity)this.target);
            int n = this.seeTime = hasSight ? this.seeTime + 1 : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                EntityKobblin.this.getNavigation().stop();
            } else {
                EntityKobblin.this.getNavigation().moveTo((Entity)this.target, this.speedModifier);
            }
            EntityKobblin.this.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
            --this.attackTime;
            if (this.attackTime == 10) {
                EntityKobblin.this.setPose(Pose.SHOOTING);
            } else if (this.attackTime == 5) {
                if (!hasSight) {
                    return;
                }
                EntityKobblin.this.performRangedAttack(this.target, Mth.clamp((float)((float)Math.sqrt(d0) / this.attackRadius), (float)0.1f, (float)1.0f));
            } else if (this.attackTime == 0) {
                EntityKobblin.this.setPose(Pose.STANDING);
                this.attackTime = Mth.floor((float)((float)Math.sqrt(d0) / this.attackRadius * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.floor((double)Mth.lerp((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            }
        }
    }
}

