/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityJungleSpider
extends EntityDivineMonster {
    public boolean climbing = false;

    public EntityJungleSpider(EntityType<? extends EntityJungleSpider> p_i48550_1_, Level p_i48550_2_) {
        super(p_i48550_1_, p_i48550_2_);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new TargetGoal<Player>(this, Player.class));
        this.targetSelector.addGoal(3, new TargetGoal<IronGolem>(this, IronGolem.class));
    }

    public double getPassengersRidingOffset() {
        return this.getBbHeight() * 0.5f;
    }

    protected PathNavigation createNavigation(Level p_175447_1_) {
        return new WallClimberNavigation((Mob)this, p_175447_1_);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return SoundEvents.SPIDER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected void playStepSound(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.playSound(SoundEvents.SPIDER_STEP, 0.15f, 1.0f);
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void makeStuckInBlock(BlockState p_213295_1_, Vec3 p_213295_2_) {
        if (!p_213295_1_.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(p_213295_1_, p_213295_2_);
        }
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        if (effectInstance.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(effectInstance);
    }

    public boolean isClimbing() {
        return this.climbing;
    }

    public void setClimbing(boolean p_70839_1_) {
        this.climbing = p_70839_1_;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data) {
        Holder<MobEffect> effect;
        if (level.getRandom().nextInt(100) == 0) {
            Skeleton skeletonentity = (Skeleton)EntityType.SKELETON.create(this.level());
            skeletonentity.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            skeletonentity.finalizeSpawn(level, instance, type, null);
            skeletonentity.startRiding((Entity)this);
        }
        if (data == null) {
            data = new GroupData();
            if (level.getDifficulty() == Difficulty.HARD && level.getRandom().nextFloat() < 0.1f * instance.getSpecialMultiplier()) {
                ((GroupData)data).setRandomEffect(level.getRandom());
            }
        }
        if (data instanceof GroupData && (effect = ((GroupData)data).effect) != null) {
            this.addEffect(new MobEffectInstance(effect, Integer.MAX_VALUE));
        }
        return data;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.JUNGLE_SPIDER.get();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityJungleSpider p_i46676_1_) {
            super((PathfinderMob)p_i46676_1_, 1.0, true);
        }

        public boolean canUse() {
            return super.canUse() && !this.mob.isVehicle();
        }

        public boolean canContinueToUse() {
            float f = this.mob.level().getLightEmission(this.mob.blockPosition());
            if (f >= 0.5f && this.mob.getRandom().nextInt(100) == 0) {
                this.mob.setTarget((LivingEntity)null);
                return false;
            }
            return super.canContinueToUse();
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return 4.0f + p_179512_1_.getBbWidth();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityJungleSpider p_i45818_1_, Class<T> p_i45818_2_) {
            super((Mob)p_i45818_1_, p_i45818_2_, true);
        }

        public boolean canUse() {
            float f = this.mob.level().getLightEmission(this.mob.blockPosition());
            return f >= 0.5f ? false : super.canUse();
        }
    }

    public static class GroupData
    implements SpawnGroupData {
        public Holder<MobEffect> effect;

        public void setRandomEffect(RandomSource p_111104_1_) {
            int i = p_111104_1_.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.MOVEMENT_SPEED;
            } else if (i <= 2) {
                this.effect = MobEffects.DAMAGE_BOOST;
            } else if (i <= 3) {
                this.effect = MobEffects.REGENERATION;
            } else if (i <= 4) {
                this.effect = MobEffects.INVISIBILITY;
            }
        }
    }
}

