/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class EntityJackOMan
extends EntityDivineMerchant {
    public EntityJackOMan(EntityType<? extends EntityDivineMerchant> type, Level worldIn) {
        super(type, worldIn, "jack_o_man");
    }

    @Override
    public String[] getChatMessages() {
        return new String[]{"message.jackoman.boo", "message.jackoman.lost", "message.jackoman.hurah", "message.jackoman.seen"};
    }

    protected void updateTrades() {
        this.addOffersFromItemListings(this.getOffers(), RecipeRegistry.Trades.JACK_O_MAN.get(this.level(), this.getRandom()), 5);
    }

    @Override
    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.JACKOMAN.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.JACKOMAN.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.JACKOMAN.get();
    }

    public static boolean rules(ServerLevelAccessor level, BlockPos pos) {
        return level.getEntitiesOfClass(EntityJackOMan.class, new AABB(pos).inflate(32.0)).isEmpty();
    }
}

