/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vanilla.overworld;

import divinerpg.registries.AttachmentRegistry;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class EntityAequorea
extends Squid {
    public EntityAequorea(EntityType<EntityAequorea> type, Level level) {
        super(type, level);
        if (!level.isClientSide()) {
            this.setData((Supplier)AttachmentRegistry.VARIANT.attachment, (byte)this.getRandom().nextInt(6));
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide()) {
            AttachmentRegistry.VARIANT.requestAttachment((Entity)this, null);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomMovementGoal(this));
        this.goalSelector.addGoal(2, (Goal)new StingAttack((PathfinderMob)this, this.getAttributeBaseValue(Attributes.MOVEMENT_SPEED), false));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public byte getColor() {
        return (Byte)AttachmentRegistry.VARIANT.get((Entity)this);
    }

    protected ParticleOptions getInkParticle() {
        return ParticleTypes.SPLASH;
    }

    static class RandomMovementGoal
    extends Goal {
        private final EntityAequorea aequorea;

        public RandomMovementGoal(EntityAequorea entity) {
            this.aequorea = entity;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int i = this.aequorea.getNoActionTime();
            if (i > 100) {
                this.aequorea.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.aequorea.getRandom().nextInt(RandomMovementGoal.reducedTickDelay((int)50)) == 0 || !this.aequorea.wasTouchingWater || !this.aequorea.hasMovementVector()) {
                float f = this.aequorea.getRandom().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.cos((float)f) * 0.2f;
                float f2 = -0.1f + this.aequorea.getRandom().nextFloat() * 0.2f;
                float f3 = Mth.sin((float)f) * 0.2f;
                this.aequorea.setMovementVector(f1, f2, f3);
            }
        }
    }

    static class StingAttack
    extends Goal {
        protected final PathfinderMob mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;

        public StingAttack(PathfinderMob aequorea, double speed, boolean followAtAllCosts) {
            this.mob = aequorea;
            this.speedModifier = speed;
            this.followingTargetEvenIfNotSeen = followAtAllCosts;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            long i = this.mob.level().getGameTime();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.getNavigation().isDone();
            }
            if (!this.mob.isWithinRestriction(livingentity.blockPosition())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.path, this.speedModifier);
            this.mob.setAggressive(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void stop() {
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget(null);
            }
            this.mob.setAggressive(false);
            this.mob.getNavigation().stop();
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            double d0 = this.mob.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }

        protected void checkAndPerformAttack(LivingEntity entity, double range) {
            double d0 = this.getAttackReachSqr(entity);
            if (range <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)entity);
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 3));
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + p_179512_1_.getBbWidth();
        }
    }
}

