/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.skythern;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;

public class EntityAdvancedCori
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    public EntityAdvancedCori(EntityType<? extends EntityAdvancedCori> type, Level worldIn) {
        super((EntityType<? extends EntityDivineFlyingMonster>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            DivineThrowableProjectile projectile = (DivineThrowableProjectile)((EntityType)EntityRegistry.CORI_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            projectile.baseDamage = 30.0f;
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            projectile.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 1.2f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CORI_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }
}

