/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.throwable;

import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.items.ranged.ItemThrowable;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityDisk
extends DivineThrownItem {
    public EntityDisk(EntityType<? extends DivineThrownItem> type, Level world) {
        super(type, world);
    }

    @Override
    public void tick() {
        super.tick();
        Entity owner = this.getOwner();
        if (owner != null && (this.tickCount & 7) == 7) {
            Vec3 vec3 = owner.getEyePosition().subtract(this.position());
            this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.03, this.getZ());
            if (this.level().isClientSide) {
                this.yOld = this.getY();
            }
            this.addDeltaMovement(vec3.scale(0.25));
            this.playSound(SoundEvents.ARROW_SHOOT, 0.5f, 1.0f);
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        if (this.getOwner() == null) {
            super.onHitBlock(result);
        } else {
            BlockState blockstate = this.level().getBlockState(result.getBlockPos());
            blockstate.onProjectileHit(this.level(), blockstate, result, (Projectile)this);
            Vec3 mv = this.getDeltaMovement();
            double x = mv.x;
            double y = mv.y;
            double z = mv.z;
            if (result.getDirection() == Direction.DOWN || result.getDirection() == Direction.UP) {
                this.lerpMotion(x * 0.6, y * -0.6, z * 0.6);
            } else if (result.getDirection() == Direction.EAST || result.getDirection() == Direction.WEST) {
                this.lerpMotion(x * -0.6, y * 0.6, z * 0.6);
            } else if (result.getDirection() == Direction.NORTH || result.getDirection() == Direction.SOUTH) {
                this.lerpMotion(x * 0.6, y * 0.6, z * -0.6);
            }
        }
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        Level level;
        float f;
        Item item;
        Entity entity;
        Entity entity1 = this.getOwner();
        if (entity1.equals((Object)(entity = result.getEntity())) && entity1 instanceof Player) {
            Player p = (Player)entity1;
            if (this.canPickup) {
                p.addItem(this.getItem());
            }
            this.discard();
            return;
        }
        ItemStack item2 = this.getItem();
        float f2 = (float)this.getDeltaMovement().length();
        if (item2.isEmpty() || !((item = item2.getItem()) instanceof ItemThrowable)) {
            f = 1.0f;
        } else {
            ItemThrowable t = (ItemThrowable)item;
            f = t.damage;
        }
        float d0 = f;
        DamageSource damagesource = this.getDamageSource(result);
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)s, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)d0);
        }
        int j = Mth.ceil((double)Mth.clamp((double)(f2 * d0), (double)0.0, (double)2.147483647E9));
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (this.isOnFire()) {
                entity.igniteForSeconds(5.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
            }
        }
        this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)ItemRegistry.teaker_disk.get();
    }
}

