/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.magic;

import divinerpg.entities.projectile.magic.DivineParticleProjectile;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.ParticleRegistry;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityLadyLunaSparkler
extends DivineParticleProjectile {
    public EntityLadyLunaSparkler(EntityType<? extends DivineParticleProjectile> type, Level world) {
        super((EntityType<? extends ThrowableProjectile>)type, world, 12.0f, (Supplier<SimpleParticleType>)ParticleRegistry.APALACHIA_PORTAL);
    }

    @Override
    public DamageSource getDamageSource(EntityHitResult result) {
        return this.level().damageSources().source(DamageRegistry.SPIKE.getKey());
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getOwner() != null && this.getOwner() instanceof LivingEntity && ((LivingEntity)this.getOwner()).getLastHurtByMob() != null) {
            double tx = ((LivingEntity)this.getOwner()).getLastHurtByMob().xo - this.getOwner().xo;
            double ty = ((LivingEntity)this.getOwner()).getLastHurtByMob().getBoundingBox().minY - this.getOwner().yo;
            double tz = ((LivingEntity)this.getOwner()).getLastHurtByMob().zo - this.getOwner().zo;
            if (!this.level().isClientSide() && this.tickCount > 30) {
                this.shoot(tx, ty, tz, 0.5f, 0.0f);
            }
        }
        if (!this.level().isClientSide() && this.tickCount > 80) {
            this.kill();
        }
    }
}

