/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.bullet;

import divinerpg.client.particle.options.ParticleColouredOption;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class EntitySoulFiendShot
extends ThrowableProjectile {
    public EntitySoulFiendShot(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    public void onHit(HitResult result) {
        if (this.tickCount > 1 && !this.level().isClientSide()) {
            for (int i = 0; i < 3; ++i) {
                ((EntityType)EntityRegistry.SOUL_SPIDER.get()).spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, new BlockPos((int)result.getLocation().x, (int)result.getLocation().y, (int)result.getLocation().z), MobSpawnType.MOB_SUMMONED, true, false);
            }
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            for (int cnt = 0; cnt < 8; ++cnt) {
                this.level().addParticle((ParticleOptions)new ParticleColouredOption((ParticleType<ParticleColouredOption>)((ParticleType)ParticleRegistry.COLORED.get()), 0), this.xo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, this.yo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, this.zo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, 0.2, 0.2, 0.2);
                this.level().addParticle((ParticleOptions)new ParticleColouredOption((ParticleType<ParticleColouredOption>)((ParticleType)ParticleRegistry.COLORED.get()), 255000), this.xo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, this.yo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, this.zo + (this.random.nextDouble() - this.random.nextDouble()) / 4.0, 0.2, 0.2, 0.2);
            }
        }
        if (!this.level().isClientSide() && this.tickCount > 20) {
            this.kill();
        }
    }
}

