/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.bullet;

import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class EntitySkyreBullet
extends DivineThrowableProjectile {
    public EntitySkyreBullet(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.setDeltaMovement(this.level().getRandom().nextGaussian() * 0.05, -0.5, this.level().getRandom().nextGaussian() * 0.05);
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    protected void doPostHurtEffects(LivingEntity entity) {
        if (entity instanceof Player) {
            entity.hurt(this.level().damageSources().source(DamageRegistry.SPIKE.getKey()), entity.getHealth() / 2.0f);
            this.level().playSound((Player)entity, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundRegistry.SKYRE_SPARK.get(), SoundSource.HOSTILE, 0.0f, 0.0f);
        }
        this.level().explode((Entity)this, this.xo, this.yo, this.zo, 4.5f, false, Level.ExplosionInteraction.MOB);
    }

    protected void onHit(HitResult result) {
        if (this.tickCount > 1 && !this.level().isClientSide()) {
            this.level().explode((Entity)this, this.xo, this.yo, this.zo, 2.0f, false, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }
}

