/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile.bullet;

import divinerpg.entities.boss.EntityKitra;
import divinerpg.entities.projectile.DivineThrowableProjectile;
import divinerpg.entities.projectile.bullet.BoneFragment;
import divinerpg.registries.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BoneBomb
extends DivineThrowableProjectile {
    public BoneBomb(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
        this.baseDamage = 16.0f;
    }

    @Override
    public void onHitEntity(EntityHitResult result) {
        if (!(result.getEntity() instanceof EntityKitra)) {
            super.onHitEntity(result);
        }
    }

    public void onHit(HitResult result) {
        super.onHit(result);
        if (result.getType() != HitResult.Type.MISS) {
            for (int i = 0; i < 64; ++i) {
                double motionX = (this.random.nextDouble() - 0.5) * 2.0;
                double motionY = (this.random.nextDouble() - 0.5) * 2.0;
                double motionZ = (this.random.nextDouble() - 0.5) * 2.0;
                BoneFragment e = (BoneFragment)((EntityType)EntityRegistry.BONE_FRAGMENT.get()).create(this.level());
                e.setOwner(this.getOwner());
                e.setPos(result.getLocation());
                e.shoot(motionX, motionY, motionZ, 1.0f, 0.0f);
                this.level().addFreshEntity((Entity)e);
            }
            this.discard();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.noPhysics = this.isInWater();
        double radius = (double)this.getBbWidth() * 1.5;
        AABB aabb = new AABB(this.getX() - radius, this.getY() - radius, this.getZ() - radius, this.getX() + radius, this.getY() + radius, this.getZ() + radius);
        BlockPos.betweenClosedStream((AABB)aabb).forEach(blockPos -> {
            BlockState blockState = this.level().getBlockState(blockPos);
            if (blockState.is(BlockTags.ICE)) {
                this.level().destroyBlock(blockPos, true);
            }
        });
    }
}

