/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.items.ranged.ItemThrowable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class DivineThrownItem
extends ThrowableItemProjectile {
    public boolean canPickup = true;

    public DivineThrownItem(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected Item getDefaultItem() {
        return Items.EGG;
    }

    public void drop() {
        ItemStack item = this.getItem();
        if (this.canPickup && !item.isEmpty()) {
            this.spawnAtLocation(this.getItem(), 0.1f);
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.drop();
        }
    }

    public DamageSource getDamageSource(EntityHitResult result) {
        return this.damageSources().thrown((Entity)this, this.getOwner());
    }

    protected void doPostHurtEffects(LivingEntity living) {
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level;
        float f;
        Item item;
        Entity entity = result.getEntity();
        ItemStack item2 = this.getItem();
        float f2 = (float)this.getDeltaMovement().length();
        if (item2.isEmpty() || !((item = item2.getItem()) instanceof ItemThrowable)) {
            f = 1.0f;
        } else {
            ItemThrowable t = (ItemThrowable)item;
            f = t.damage;
        }
        float d0 = f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.getDamageSource(result);
        if (this.getWeaponItem() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)s, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)d0);
        }
        int j = Mth.ceil((double)Mth.clamp((double)(f2 * d0), (double)0.0, (double)2.147483647E9));
        int i = entity.getRemainingFireTicks();
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        if (this.isOnFire()) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
            }
            this.canPickup = false;
            this.drop();
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                this.drop();
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.drop();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("pickup", this.canPickup);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.canPickup = compound.getBoolean("pickup");
    }
}

