/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals.miner;

import divinerpg.entities.vanilla.overworld.EntityMiner;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class StoreInChestGoal
extends Goal {
    private final EntityMiner miner;
    private BlockPos chestLocation;

    public StoreInChestGoal(EntityMiner miner) {
        this.miner = miner;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return !this.miner.getInventory().isEmpty();
    }

    public void start() {
        if (this.chestLocation != null) {
            this.miner.getNavigation().moveTo((double)this.chestLocation.getX() + 0.5, (double)this.chestLocation.getY() + 0.5, (double)this.chestLocation.getZ() + 0.5, 1.0);
        }
    }

    public boolean canContinueToUse() {
        boolean canContinue = !this.miner.getInventory().isEmpty() && this.chestLocation != null && this.miner.distanceToSqr((double)this.chestLocation.getX() + 0.5, (double)this.chestLocation.getY() + 0.5, (double)this.chestLocation.getZ() + 0.5) > 5.0;
        return canContinue;
    }

    public void tick() {
        if (this.chestLocation == null) {
            this.chestLocation = this.findNearbyChest();
        }
        if (this.chestLocation != null && this.miner.distanceToSqr((double)this.chestLocation.getX() + 0.5, (double)this.chestLocation.getY() + 0.5, (double)this.chestLocation.getZ() + 0.5) <= 5.0) {
            this.storeItemsInChest();
        }
    }

    private BlockPos findNearbyChest() {
        BlockPos origin = this.miner.blockPosition();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    checkPos.set(origin.getX() + x, origin.getY() + y, origin.getZ() + z);
                    if (!this.miner.level().getBlockState((BlockPos)checkPos).is(BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"chests")))) continue;
                    return checkPos.immutable();
                }
            }
        }
        return null;
    }

    private void storeItemsInChest() {
        BlockEntity blockEntity = this.miner.level().getBlockEntity(this.chestLocation);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlockEntity;
            ChestBlockEntity chestInventory = chestBlockEntity = (ChestBlockEntity)blockEntity;
            block0: for (int i = 0; i < this.miner.getInventory().getContainerSize(); ++i) {
                ItemStack minerStack = this.miner.getInventory().getItem(i);
                if (minerStack.isEmpty()) continue;
                for (int j = 0; j < chestInventory.getContainerSize(); ++j) {
                    ItemStack chestStack = chestInventory.getItem(j);
                    if (chestStack.isEmpty()) {
                        chestInventory.setItem(j, minerStack.copy());
                        this.miner.getInventory().setItem(i, ItemStack.EMPTY);
                        continue block0;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)minerStack, (ItemStack)chestStack) || chestStack.getCount() >= chestStack.getMaxStackSize()) continue;
                    int transferAmount = Math.min(minerStack.getCount(), chestStack.getMaxStackSize() - chestStack.getCount());
                    chestStack.grow(transferAmount);
                    minerStack.shrink(transferAmount);
                    if (!minerStack.isEmpty()) continue;
                    this.miner.getInventory().setItem(i, ItemStack.EMPTY);
                    continue block0;
                }
            }
            chestBlockEntity.setChanged();
        }
    }
}

