/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.goals;

import divinerpg.entities.vanilla.overworld.EntityAequorea;
import divinerpg.registries.DamageRegistry;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class TurtleEatAequoreaGoal
extends Goal {
    Turtle turtle;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public TurtleEatAequoreaGoal(Turtle turtle, double speed, boolean followAtAllCosts) {
        this.turtle = turtle;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = followAtAllCosts;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.turtle.getTarget() instanceof EntityAequorea;
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.turtle.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.turtle.getNavigation().isDone();
        }
        if (!this.turtle.isWithinRestriction(livingentity.blockPosition())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
    }

    public void start() {
        this.turtle.getNavigation().moveTo(this.path, this.speedModifier);
        this.turtle.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingentity = this.turtle.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.turtle.setTarget((LivingEntity)null);
        }
        this.turtle.setAggressive(false);
        this.turtle.getNavigation().stop();
    }

    public void tick() {
        LivingEntity livingentity = this.turtle.getTarget();
        this.turtle.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.turtle.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.turtle.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.turtle.getRandom().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.getX();
            this.pathedTargetY = livingentity.getY();
            this.pathedTargetZ = livingentity.getZ();
            this.ticksUntilNextPathRecalculation = 4 + this.turtle.getRandom().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.turtle.getNavigation().getPath() != null ? ((finalPathPoint = this.turtle.getNavigation().getPath().getEndNode()) != null && livingentity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.turtle.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity entity, double range) {
        double d0 = this.getAttackReachSqr(entity);
        if (range <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            entity.hurt(entity.level().damageSources().source(DamageRegistry.TURTLE.getKey()), entity.getHealth());
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.turtle.getBbWidth() * 2.0f * this.turtle.getBbWidth() * 2.0f + p_179512_1_.getBbWidth();
    }
}

