/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityWeakCori
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    public EntityWeakCori(EntityType<? extends EntityWeakCori> type, Level worldIn) {
        super((EntityType<? extends EntityDivineFlyingMonster>)type, worldIn);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.CORI_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            projectile.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CORI_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    public static boolean weakCoriSpawnRule(BlockPos pos, RandomSource randomIn) {
        return pos.getY() > 128;
    }
}

