/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.eden;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.arrows.EdenArrow;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntitySunArcher
extends EntityDivineMonster
implements RangedAttackMob {
    public EntitySunArcher(EntityType<? extends EntitySunArcher> type, Level worldIn) {
        super(type, worldIn);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.getAttribute(Attributes.MOVEMENT_SPEED).getBaseValue(), 30, (float)this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue()));
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null) {
            EdenArrow abstractarrow = new EdenArrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)ItemRegistry.eden_arrow.get()), new ItemStack((ItemLike)ItemRegistry.eden_bow.get()));
            abstractarrow.powerMultiplier = 1.5f;
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrow);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }
}

