/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineFlyingMonster;
import divinerpg.entities.projectile.DivineThrownItem;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class EntityTermasect
extends EntityDivineFlyingMonster
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);

    public EntityTermasect(EntityType<? extends EntityDivineFlyingMonster> type, Level worldIn) {
        super(type, worldIn, 25.0f);
        this.xpReward = 50;
    }

    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)this.getName()).withStyle(s -> s.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()).withBold(Boolean.valueOf(true)));
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.goalSelector.addGoal(1, (Goal)new FlyToPlayer(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            DivineThrownItem shot = (DivineThrownItem)((EntityType)EntityRegistry.THROWN_ITEM.get()).create(this.level());
            shot.setItem(BlockRegistry.wildwoodLog.asItem().getDefaultInstance());
            shot.setOwner((Entity)this);
            shot.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - shot.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            shot.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.5f);
            this.level().addFreshEntity((Entity)shot);
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WOOD_STEP;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOOD_HIT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOD_BREAK;
    }

    @Override
    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.getTarget() != null && this.isAlive() && this.ambientSoundTime % (20 * (10 + this.random.nextInt(10))) == 0) {
            double tx = this.getTarget().getX() - this.getX();
            double ty = this.getTarget().getEyeY() - this.getEyeY();
            double tz = this.getTarget().getZ() - this.getZ();
            DivineThrownItem e = (DivineThrownItem)((EntityType)EntityRegistry.THROWN_ITEM.get()).create(this.level());
            e.setItem(BlockRegistry.wildwoodLog.asItem().getDefaultInstance());
            e.setOwner((Entity)this);
            e.setPos(this.getEyePosition());
            double horizontalDistance = Math.sqrt(tx * tx + tz * tz);
            e.shoot(tx, ty, tz, 2.6f, 0.0f);
            e.setDeltaMovement(tx / horizontalDistance * (double)1.6f, ty / horizontalDistance * (double)1.6f, tz / horizontalDistance * (double)1.6f);
            this.level().addFreshEntity((Entity)e);
        }
        if (this.isAlive() && this.ambientSoundTime % (20 * (15 + this.random.nextInt(5))) == 0) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getX() + (double)this.random.nextInt(8), this.getY(), this.getZ() + (double)this.random.nextInt(8));
            ((EntityType)EntityRegistry.TERMID.get()).spawn((ServerLevel)this.level(), ItemStack.EMPTY, null, (BlockPos)pos, MobSpawnType.MOB_SUMMONED, true, false);
        }
        if (this.level().isRaining() && this.level().canSeeSky(this.blockPosition()) && this.level().getRandom().nextInt(50) == 3) {
            this.heal(5.0f);
        }
    }

    public void playerTouch(Player player) {
        super.playerTouch(player);
        player.hurt(this.damageSources().flyIntoWall(), 4.0f);
        player.knockback(2.1, 2.1, 2.1);
    }

    static class FlyToPlayer
    extends Goal {
        private final EntityDivineFlyingMonster parentEntity;
        private final double followDistanceSq;

        public FlyToPlayer(EntityDivineFlyingMonster ent) {
            this.parentEntity = ent;
            this.followDistanceSq = ent.getAttributeValue(Attributes.FOLLOW_RANGE) * ent.getAttributeValue(Attributes.FOLLOW_RANGE);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return true;
        }

        public void start() {
            this.parentEntity.getNavigation().stop();
        }

        public boolean canContinueToUse() {
            return this.parentEntity.getTarget() != null && this.parentEntity.distanceToSqr((Entity)this.parentEntity.getTarget()) > this.followDistanceSq;
        }

        public void tick() {
            double d2;
            double d1;
            LivingEntity target = this.parentEntity.getTarget();
            if (target == null) {
                return;
            }
            double d0 = target.getX() - this.parentEntity.getX();
            double distSq = d0 * d0 + (d1 = target.getY(0.3333333333333333) - this.parentEntity.getY()) * d1 + (d2 = target.getZ() - this.parentEntity.getZ()) * d2;
            if (distSq < this.followDistanceSq) {
                return;
            }
            double speed = this.parentEntity.getAttributeValue(Attributes.MOVEMENT_SPEED);
            this.parentEntity.setDeltaMovement(this.parentEntity.getDeltaMovement().add((Math.signum(d0) * 0.5 - this.parentEntity.getDeltaMovement().x) * (double)0.1f * speed, (Math.signum(d1) * (double)0.7f - this.parentEntity.getDeltaMovement().y) * (double)0.1f * speed, (Math.signum(d2) * 0.5 - this.parentEntity.getDeltaMovement().z) * (double)0.1f * speed));
            this.parentEntity.lookAt((Entity)target, 30.0f, 30.0f);
        }
    }
}

