/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EntityParasecta
extends EntityDivineBoss {
    private BlockPos currentFlightTarget;

    public EntityParasecta(EntityType<? extends EntityParasecta> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.getTarget() != null) {
            int x = (int)this.getTarget().getX();
            int y = (int)this.getTarget().getY();
            int z = (int)this.getTarget().getZ();
            this.currentFlightTarget = new BlockPos(x, y, z);
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        if (this.currentFlightTarget != null) {
            double x = (double)this.currentFlightTarget.getX() - this.getX();
            double y = (double)this.currentFlightTarget.getY() - this.getY();
            double z = (double)this.currentFlightTarget.getZ() - this.getZ();
            if (Math.signum(x) != 0.0 || Math.signum(y) != 0.0 || Math.signum(z) != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().x + (Math.signum(x) * 0.5 - this.getDeltaMovement().x) * 0.1, this.getDeltaMovement().y + (Math.signum(y) * 1.7 - this.getDeltaMovement().y) * 0.1, this.getDeltaMovement().z + (Math.signum(z) * 0.5 - this.getDeltaMovement().z) * 0.1);
                float var7 = (float)(Math.atan2(this.getDeltaMovement().z, this.getDeltaMovement().x) * 57.2957763671875) - 90.0f;
                float var8 = Mth.wrapDegrees((float)(var7 - this.getXRot()));
                this.moveDist = 0.5f;
                this.xRotO += var8;
            }
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected SoundEvent getAmbientSound() {
        return this.random.nextInt(4) != 0 ? null : (SoundEvent)SoundRegistry.PARASECTA.get();
    }

    protected SoundEvent getHurtSound(DamageSource s) {
        return (SoundEvent)SoundRegistry.PARASECTA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.PARASECTA_HURT.get();
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }
}

