/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.projectile.magic.EntityLadyLunaSparkler;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityLadyLuna
extends EntityDivineBoss {
    private int protectionTimer;
    private final List<BlockPos> acidPositions = new ArrayList<BlockPos>();

    public EntityLadyLuna(EntityType<? extends EntityLadyLuna> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
        this.setProtectionTimer(200 + this.random.nextInt(200));
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide()) {
            AttachmentRegistry.VARIANT.requestAttachment((Entity)this, null);
        }
    }

    public int getProtection() {
        return AttachmentRegistry.VARIANT.getOrDefault((Entity)this, (byte)2).byteValue();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level.isClientSide()) {
            return;
        }
        if (this.tickCount % 5 == 0) {
            for (int x = (int)this.getX() - 2; x < (int)this.getX() + 2; ++x) {
                for (int y = (int)this.getBoundingBox().minY; y < (int)this.getBoundingBox().minY + 4; ++y) {
                    for (int z = (int)this.getZ() - 2; z < (int)this.getZ() + 2; ++z) {
                        if (!level.getBlockState(new BlockPos(x, y, z)).is(BlockTags.LEAVES) && !level.getBlockState(new BlockPos(x, y, z)).is(BlockTags.LOGS)) continue;
                        level.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 1);
                    }
                }
            }
        }
        BlockPos current = new BlockPos((int)this.getX() - 1, (int)this.getY(), (int)this.getZ() - 1);
        BlockPos below = new BlockPos((int)this.getX() - 1, (int)this.getY() - 1, (int)this.getZ() - 1);
        BlockState belowState = level.getBlockState(below);
        if (level.getBlockState(current).getBlock() == Blocks.AIR && belowState.canOcclude() && belowState.hasLargeCollisionShape()) {
            level.setBlock(current, ((Block)BlockRegistry.lunicAcid.get()).defaultBlockState(), 1);
            this.acidPositions.add(current);
        }
        if (this.getProtection() == 0 && this.tickCount % 30 == 0) {
            Iterator<BlockPos> iter = this.acidPositions.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (level.getBlockState(pos).getBlock() != BlockRegistry.lunicAcid.get()) {
                    iter.remove();
                    continue;
                }
                if (this.random.nextInt(4) != 0) continue;
                EntityLadyLunaSparkler e = (EntityLadyLunaSparkler)((EntityType)EntityRegistry.LADY_LUNA_SPARKLER.get()).create(level);
                e.setOwner((Entity)this);
                e.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)e);
            }
        }
        if (this.getProtectionTimer() == 0) {
            this.setRandomProtectionValues();
        } else if (this.getProtectionTimer() > 0) {
            this.setProtectionTimer(this.getProtectionTimer() - 1);
        }
    }

    public void setProtectionType(int i) {
        AttachmentRegistry.VARIANT.set((Entity)this, (byte)i);
        if (i == 0) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        } else {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.32);
        }
    }

    public void setProtectionTimer(int i) {
        this.protectionTimer = i;
    }

    public int getProtectionTimer() {
        return this.protectionTimer;
    }

    public boolean hurt(DamageSource source, float par2) {
        if (source.is(DamageTypes.EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.MAGIC) && this.getProtection() == 0) {
            return false;
        }
        if ((source.is(DamageTypes.MOB_PROJECTILE) || source.getMsgId().equals("thrown")) && this.getProtection() == 1) {
            return false;
        }
        if (!source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) && this.getProtection() == 2) {
            return false;
        }
        return super.hurt(source, par2);
    }

    public boolean doHurtTarget(Entity e) {
        int dam = 20;
        Level level = this.level();
        boolean var4 = e.hurt(level.damageSources().mobAttack((LivingEntity)this), (float)dam);
        if (var4) {
            level.explode((Entity)this, e.getX(), e.getY(), e.getZ(), 2.0f, Level.ExplosionInteraction.BLOCK);
            this.xo *= 0.6;
            this.zo *= 0.6;
            int var5 = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FIRE_ASPECT), (LivingEntity)this);
            if (var5 > 0) {
                e.igniteForSeconds((float)(var5 * 4));
            }
        }
        return var4;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ImmunityCooldown", this.getProtectionTimer());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setProtectionTimer(tag.getInt("ImmunityCooldown"));
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.LADY_LUNA.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.LADY_LUNA_HURT.get();
    }

    private void setRandomProtectionValues() {
        this.setProtectionType(this.random.nextInt(2));
        this.setProtectionTimer(200 + this.random.nextInt(200));
    }
}

