/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.projectile.bullet.BoneBomb;
import divinerpg.entities.vanilla.overworld.EntityWhale;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.EntityRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class EntityKitra
extends EntityWhale
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setCreateWorldFog(true);

    public EntityKitra(EntityType<? extends EntityWhale> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected int getBaseExperienceReward() {
        return 50;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, (double)0.27f, 80, 32.0f));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public Component getDisplayName() {
        return PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)this.getName()).withStyle(s -> s.withHoverEvent(this.createHoverEvent()).withInsertion(this.getStringUUID()).withBold(Boolean.valueOf(true)).withColor(10810617));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void performRangedAttack(LivingEntity entity, float f) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            BoneBomb e = (BoneBomb)((EntityType)EntityRegistry.BONE_BOMB.get()).create(this.level());
            double dx = this.getTarget().getX() - this.getX();
            double dy = this.getTarget().getY() - this.getY();
            double dz = this.getTarget().getZ() - this.getZ();
            e.setOwner((Entity)this);
            e.shoot(dx, dy, dz, 1.5f, 0.8f);
            e.setPos(this.position().x, this.position().y + 1.5, this.position().z);
            this.level().addFreshEntity((Entity)e);
            this.hurt(this.damageSources().magic(), 10.0f);
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double speed = this.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
            double motionX = (dx /= distance) * speed;
            double motionY = (dy /= distance) * speed;
            double motionZ = (dz /= distance) * speed;
            this.setDeltaMovement(this.getDeltaMovement().x + motionX, this.getDeltaMovement().y + motionY, this.getDeltaMovement().z + motionZ);
        }
    }

    protected void customServerAiStep() {
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.random.nextInt(500) == 0) {
            double x = this.getX() + (this.random.nextDouble() - 0.5) * 8.0;
            double y = this.getY();
            double z = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0;
            BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
            BlockState state = this.level().getBlockState(pos);
            if (state.getFluidState().is(FluidTags.WATER)) {
                List<EntityType> fishEntities = Arrays.asList(EntityType.PUFFERFISH, (EntityType)EntityRegistry.SHARK.get(), (EntityType)EntityRegistry.AEQUOREA.get(), EntityType.GLOW_SQUID);
                EntityType randomFishEntity = fishEntities.get(this.level().getRandom().nextInt(fishEntities.size()));
                if (this.level().noCollision(randomFishEntity.getSpawnAABB(x, y, z).deflate(0.0625))) {
                    randomFishEntity.spawn((ServerLevel)this.level(), pos, MobSpawnType.REINFORCEMENT);
                }
            } else if (state.isAir() && this.level().noCollision(((EntityType)EntityRegistry.ALICANTO.get()).getSpawnAABB(x, y, z))) {
                ((EntityType)EntityRegistry.ALICANTO.get()).spawn((ServerLevel)this.level(), pos, MobSpawnType.REINFORCEMENT);
            }
        }
        for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(16.0))) {
            if (player.isSpectator() || player.isCreative() || !player.isAlive() || this.random.nextInt(500) != 0) continue;
            player.addEffect(this.getRandomNegativeEffect());
        }
        for (Boat boat : this.level().getEntitiesOfClass(Boat.class, this.getBoundingBox().inflate(4.0))) {
            boat.hurt(this.damageSources().generic(), 100.0f);
        }
        if (this.isAlive()) {
            AABB box = this.getBoundingBox().inflate(1.5);
            BlockPos.betweenClosedStream((BlockPos)new BlockPos((int)box.minX, (int)box.minY, (int)box.minZ), (BlockPos)new BlockPos((int)box.maxX, (int)box.maxY, (int)box.maxZ)).forEach(blockPos -> {
                BlockState state = this.level().getBlockState(blockPos);
                if (state.is(BlockTags.ICE)) {
                    if (blockPos.getY() == this.level().getSeaLevel()) {
                        this.level().setBlockAndUpdate(blockPos, Blocks.WATER.defaultBlockState());
                    } else {
                        this.level().destroyBlock(blockPos, false);
                    }
                    this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
                }
            });
        }
    }

    private MobEffectInstance getRandomNegativeEffect() {
        List<Holder> negativeEffects = Arrays.asList(MobEffects.BLINDNESS, MobEffects.HUNGER, MobEffects.POISON, MobEffects.WITHER, MobEffects.BAD_OMEN, MobEffects.CONFUSION, MobEffects.DIG_SLOWDOWN, MobEffects.WEAKNESS, MobEffects.UNLUCK);
        Holder negativeEffect = negativeEffects.get(this.random.nextInt(negativeEffects.size()));
        int duration = 20 * (this.random.nextInt(60) + 30);
        int amplifier = this.random.nextInt(2);
        return new MobEffectInstance(negativeEffect, duration, amplifier);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || !source.is(DamageTypes.MAGIC) && !source.is(DamageRegistry.ARCANA.getKey()) && !source.is(DamageTypes.FELL_OUT_OF_WORLD) && !source.is(DamageTypes.EXPLOSION) && !source.is(DamageTypes.LIGHTNING_BOLT) && !source.is(DamageTypes.DRAGON_BREATH) && !source.is(DamageTypes.INDIRECT_MAGIC) && !source.is(DamageTypes.WITHER) && !source.is(DamageTypes.GENERIC_KILL);
    }

    public boolean canBeHitByProjectile() {
        return true;
    }
}

