/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityKingOfScorchers
extends EntityDivineBoss
implements RangedAttackMob {
    public EntityKingOfScorchers(EntityType<? extends EntityKingOfScorchers> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 32.0f));
        this.goalSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.getY() - this.getY()) <= 4.0));
    }

    public void performRangedAttack(LivingEntity entity, float range) {
        if (this.isAlive() && !this.level().isClientSide && this.getTarget() != null) {
            Vec3 vector3d = this.getViewVector(1.0f);
            double d0 = this.getTarget().getX() - (this.getX() + vector3d.x * 4.0);
            double d1 = this.getTarget().getY(0.5) - (0.5 + this.getY(0.5));
            double d2 = this.getTarget().getZ() - (this.getZ() + vector3d.z * 4.0);
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.KING_OF_SCORCHERS_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            if (this.level().getRandom().nextInt(10) == 0) {
                projectile = (ThrowableProjectile)((EntityType)EntityRegistry.KING_OF_SCORCHERS_METEOR.get()).create(this.level());
                projectile.setOwner((Entity)this);
                projectile.setPos(this.getEyePosition());
                for (int i = 0; i < 4; ++i) {
                    projectile.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
                    this.level().addFreshEntity((Entity)projectile);
                }
            } else {
                projectile.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
                this.level().addFreshEntity((Entity)projectile);
            }
        }
    }

    public int getArmorValue() {
        return 10;
    }

    public boolean hurt(DamageSource source, float par2) {
        if (source.is(DamageTypes.EXPLOSION)) {
            return false;
        }
        return super.hurt(source, par2);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.KING_OF_SCORCHERS.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.KING_OF_SCORCHERS_HURT.get();
    }
}

