/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.blocks.vethea.BlockHelioticBeam;
import divinerpg.blocks.vethea.BlockKarosDispenser;
import divinerpg.blocks.vethea.BlockKarosHeatTile;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EntityKaros
extends EntityDivineBoss {
    private int ability = 0;
    private static final int DEFAULT = 0;
    private static final int CEILING = 1;
    private static final int CANNONS = 2;
    private static final int FLOOR = 3;
    private int abilityCooldown;
    private boolean hasLoadedBlocks = false;
    private final List<BlockPos> ceiling = new ArrayList<BlockPos>();
    private final List<BlockPos> cannons = new ArrayList<BlockPos>();

    public EntityKaros(EntityType<? extends EntityKaros> type, Level worldIn) {
        super((EntityType<? extends EntityDivineBoss>)type, worldIn);
    }

    @Override
    protected void customServerAiStep() {
        this.manageAbilities();
        super.customServerAiStep();
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(8, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 1.0f, 1.0f));
        this.goalSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Piglin.class}));
        this.goalSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void manageAbilities() {
        block9: {
            block8: {
                if (this.abilityCooldown != 0) break block8;
                this.abilityCooldown = 200;
                switch (this.random.nextInt(3)) {
                    case 0: {
                        this.ability = 1;
                        this.playSound((SoundEvent)SoundRegistry.CEILING_EXPLOSIONS.get(), 1.0f, 1.0f);
                        if (!this.level().isClientSide()) {
                            List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
                            for (Player p : players) {
                                p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.karos.explosion", new Object[0]), true);
                            }
                        }
                        break block9;
                    }
                    case 1: {
                        this.ability = 2;
                        break;
                    }
                    case 2: {
                        this.ability = 3;
                        break;
                    }
                }
                break block9;
            }
            if (this.abilityCooldown > 0) {
                --this.abilityCooldown;
            }
        }
    }

    public boolean hurt(DamageSource source, float par2) {
        if (source.is(DamageTypes.EXPLOSION)) {
            return false;
        }
        return super.hurt(source, par2);
    }

    public void tick() {
        block15: {
            Block currentBlock;
            block14: {
                super.tick();
                if (!this.hasLoadedBlocks) {
                    if (!this.level().isClientSide()) {
                        List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0));
                        for (Player p : players) {
                            this.level().playSound(p, p.blockPosition(), (SoundEvent)SoundRegistry.KAROS_INTRO.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                            p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.karos.game", new Object[0]), true);
                            p.displayClientMessage(LocalizeUtils.getClientSideTranslation("message.karos.begin", new Object[0]), true);
                        }
                    }
                    for (int x = -40; x < 40; ++x) {
                        for (int y = -5; y < 20; ++y) {
                            for (int z = -40; z < 40; ++z) {
                                BlockPos currentPos = this.blockPosition().offset(x, y, z);
                                Block currentBlock2 = this.level().getBlockState(currentPos).getBlock();
                                if (currentBlock2 == BlockRegistry.helioticBeam.get()) {
                                    this.ceiling.add(currentPos);
                                    continue;
                                }
                                if (currentBlock2 != BlockRegistry.karosDispenser.get()) continue;
                                this.cannons.add(currentPos);
                            }
                        }
                    }
                    this.hasLoadedBlocks = true;
                }
                if (this.ability != 1 || this.ceiling.isEmpty()) break block14;
                if (this.abilityCooldown % 8 != 0) break block15;
                BlockPos currentPos = this.ceiling.get(this.random.nextInt(this.ceiling.size()));
                currentBlock = this.level().getBlockState(currentPos).getBlock();
                if (!(currentBlock instanceof BlockHelioticBeam)) break block15;
                ((BlockHelioticBeam)currentBlock).dropBomb(this.level(), currentPos);
                break block15;
            }
            if (this.ability == 2 && !this.cannons.isEmpty()) {
                if (this.abilityCooldown % 4 == 0) {
                    BlockPos currentPos = this.cannons.get(this.random.nextInt(this.cannons.size()));
                    currentBlock = this.level().getBlockState(currentPos).getBlock();
                    if (currentBlock instanceof BlockKarosDispenser) {
                        ((BlockKarosDispenser)currentBlock).dispenseFrom(this.level().getServer().getLevel(this.level().dimension()), currentPos);
                    }
                } else if (this.ability == 3) {
                    for (int i = 0; i < 3; ++i) {
                        for (double var4 = 0.0; var4 < Math.PI * 2; var4 += 0.39269908169872414) {
                            int var1 = (int)Math.round(Math.sin(var4) * (double)i);
                            int var3 = (int)Math.round(Math.cos(var4) * (double)i);
                            BlockPos currentPos = new BlockPos((int)this.getX() + var1, (int)this.getY() - 1, (int)this.getZ() + var3);
                            if (this.level().getBlockState(currentPos).getBlock() != BlockRegistry.karosHeatTile.get()) continue;
                            this.level().setBlock(currentPos, (BlockState)((Block)BlockRegistry.karosHeatTile.get()).defaultBlockState().setValue((Property)BlockKarosHeatTile.ACTIVE, (Comparable)Boolean.valueOf(true)), 0);
                        }
                    }
                }
            }
        }
    }

    protected float getSoundVolume() {
        return 0.7f;
    }

    protected SoundEvent getAmbientSound() {
        String langKey;
        SoundEvent sound = switch (this.random.nextInt(4)) {
            case 0 -> {
                langKey = "message.karos.laugh";
                yield (SoundEvent)SoundRegistry.KAROS_LAUGH.get();
            }
            case 1 -> {
                langKey = "message.karos.doom";
                yield (SoundEvent)SoundRegistry.MEET_DOOM.get();
            }
            case 2 -> {
                langKey = "message.karos.cmon";
                yield (SoundEvent)SoundRegistry.TRY_YOUR_BEST.get();
            }
            default -> {
                langKey = "message.karos.weak";
                yield (SoundEvent)SoundRegistry.YOU_CANT_KILL_ME.get();
            }
        };
        this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(30.0, 30.0, 30.0)).forEach(x -> x.displayClientMessage(LocalizeUtils.getClientSideTranslation(langKey, new Object[0]), true));
        return sound;
    }

    public SoundEvent getHurtSound(DamageSource damageSource) {
        return null;
    }

    public SoundEvent getDeathSound() {
        return null;
    }
}

