/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.AttachmentRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public abstract class EntityDivineNeutral
extends EntityDivineMonster
implements NeutralMob {
    private UUID angry_at;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);

    public EntityDivineNeutral(EntityType<? extends EntityDivineNeutral> type, Level worldIn) {
        super(type, worldIn);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.level().isClientSide()) {
            AttachmentRegistry.ANGRY.requestAttachment((Entity)this, null);
        }
    }

    @Override
    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityDivineNeutral)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        super.registerGoals();
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public boolean isPreventingPlayerRest(Player player) {
        return this.isAngryAt((LivingEntity)player);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void setRemainingPersistentAngerTime(int time) {
        AttachmentRegistry.ANGER_TIME.set((Entity)this, time);
    }

    public int getRemainingPersistentAngerTime() {
        return AttachmentRegistry.ANGER_TIME.get((Entity)this);
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angry_at = target;
        AttachmentRegistry.ANGRY.set((Entity)this, target != null);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        if (((Boolean)AttachmentRegistry.ANGRY.get((Entity)this)).booleanValue()) {
            return this.angry_at;
        }
        return null;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("angryAt")) {
            this.angry_at = compound.getUUID("angryAt");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        UUID angry_at = this.getPersistentAngerTarget();
        if (angry_at != null) {
            compound.putUUID("angryAt", angry_at);
        }
    }
}

