/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.registries.SoundRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDivineMerchant
extends AbstractVillager {
    String profession;

    public EntityDivineMerchant(EntityType<? extends EntityDivineMerchant> type, Level level, String profession) {
        super(type, level);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.profession = profession;
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        int i = 3 + this.random.nextInt(4);
        if (offer.shouldRewardExp()) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!(player.getItemInHand(hand).getItem() instanceof SpawnEggItem) && this.isAlive() && !this.isSleeping() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                boolean hasOffers;
                boolean bl = hasOffers = !this.getOffers().isEmpty();
                if (hand == InteractionHand.MAIN_HAND) {
                    player.awardStat(Stats.TALKED_TO_VILLAGER);
                    if (hasOffers && this.canTrade(player)) {
                        this.setTradingPlayer(player);
                        this.openTradingScreen(player, (Component)Component.translatable((String)("entity.divinerpg." + this.profession)), 0);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean canRestock() {
        return true;
    }

    public boolean showProgressBar() {
        return false;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    protected void stopTrading() {
        super.stopTrading();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        if (this.level() instanceof ServerLevel) {
            for (MerchantOffer merchantoffer : this.getOffers()) {
                merchantoffer.resetSpecialPriceDiff();
            }
        }
    }

    private boolean canTrade(Player player) {
        return player.isAlive() && !player.isSleeping();
    }

    public void setTradingPlayer(@javax.annotation.Nullable Player player) {
        if (this.getTradingPlayer() != player && player != null && this.canTrade(player)) {
            super.setTradingPlayer(player);
        }
    }

    public abstract String[] getChatMessages();

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.MERCHANT_HURT.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean isYesSound) {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)SoundRegistry.MERCHANT.get();
    }

    public void playCelebrateSound() {
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType type) {
        return !level.getBiome(this.blockPosition()).is(Tags.Biomes.IS_MUSHROOM) && !level.getBiome(this.blockPosition()).is(Biomes.DEEP_DARK);
    }

    public static class DivineMapTrades
    extends DivineTrades {
        public final String displayName;
        private final TagKey<Structure> destination;
        public final Holder<MapDecorationType> destinationType;

        public DivineMapTrades(ItemStack input1, ItemStack input2, String displayName, TagKey<Structure> destination, Holder<MapDecorationType> destinationType, int xp) {
            super(input1, input2, null, 1, xp);
            this.displayName = displayName;
            this.destination = destination;
            this.destinationType = destinationType;
        }

        public DivineMapTrades(ItemStack input1, String displayName, TagKey<Structure> destination, Holder<MapDecorationType> destinationType, int xp) {
            this(input1, null, displayName, destination, destinationType, xp);
        }

        @Override
        @javax.annotation.Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource rand) {
            ServerLevel serverlevel;
            BlockPos blockpos;
            Level level = entity.level();
            if (level instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)level).findNearestMapStructure(this.destination, entity.blockPosition(), 100, true)) != null) {
                ItemStack itemstack = MapItem.create((Level)serverlevel, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", this.destinationType);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), Optional.of(new ItemCost((ItemLike)this.input2.getItem(), this.input2.getCount())), itemstack, 1, this.xp, 0.0f);
            }
            return null;
        }
    }

    public static class DivineTrades
    implements VillagerTrades.ItemListing {
        public Component name;
        public final ItemStack input1;
        public final ItemStack input2;
        public final ItemStack output;
        protected int xp;
        protected int stock;

        public DivineTrades(ItemStack input1, ItemStack input2, ItemStack output, int stock, int xp) {
            this.xp = xp;
            this.stock = stock + 1;
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
        }

        public DivineTrades(ItemStack input1, ItemStack output, int stock, int xp) {
            this(input1, null, output, stock, xp);
        }

        public MerchantOffer getOffer(Entity tradeEnt, RandomSource rand) {
            if (this.input2 != null) {
                return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), Optional.of(new ItemCost((ItemLike)this.input2.getItem(), this.input2.getCount())), this.output, this.stock, this.xp, 0.0f);
            }
            return new MerchantOffer(new ItemCost((ItemLike)this.input1.getItem(), this.input1.getCount()), this.output, this.stock, this.xp, 0.0f);
        }
    }
}

