/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public abstract class EntityDivineFlyingMonster
extends EntityDivineMonster {
    @Nullable
    protected Vec3 pathfindPos;
    protected final float preferredHeight;
    protected final float preferredDistance;
    protected final float pathFindDistance;

    protected EntityDivineFlyingMonster(EntityType<? extends EntityDivineFlyingMonster> type, Level worldIn) {
        super(type, worldIn);
        this.preferredHeight = 5.0f;
        this.preferredDistance = 8.0f;
        this.pathFindDistance = 14.0f;
    }

    protected EntityDivineFlyingMonster(EntityType<? extends EntityDivineFlyingMonster> type, Level worldIn, float pathFindDistance) {
        super(type, worldIn);
        this.preferredHeight = 5.0f;
        this.preferredDistance = 8.0f;
        this.pathFindDistance = pathFindDistance;
    }

    protected EntityDivineFlyingMonster(EntityType<? extends EntityDivineFlyingMonster> type, Level worldIn, float preferredHeight, float preferredDistance, float pathFindDistance) {
        super(type, worldIn);
        this.preferredHeight = preferredHeight;
        this.preferredDistance = preferredDistance;
        this.pathFindDistance = pathFindDistance;
    }

    protected PathNavigation createNavigation(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean onClimbable() {
        return false;
    }

    public void reachTarget() {
    }

    protected void customServerAiStep() {
        this.flyingAIStep();
    }

    public void flyingAIStep() {
        boolean blockedPath;
        if (!this.isNoGravity()) {
            this.setNoGravity(true);
        }
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.5, this.getDeltaMovement().z);
            this.pathfindPos = null;
            this.getNavigation().stop();
            return;
        }
        boolean bl = blockedPath = this.horizontalCollision || this.verticalCollision;
        if (!blockedPath) {
            Vec3 futurePos = this.position().add(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
            BlockPos pos = new BlockPos((int)futurePos.x, (int)futurePos.y, (int)futurePos.z);
            BlockState state = this.level().getBlockState(pos);
            blockedPath = state.is(Blocks.POWDER_SNOW) || state.is(Blocks.LAVA) || !state.getCollisionShape((BlockGetter)this.level(), pos).equals(Shapes.empty());
        }
        LivingEntity target = this.getTarget();
        if (this.pathfindPos == null || blockedPath) {
            double findX = this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.pathFindDistance;
            double findY = this.getY() + ((double)this.random.nextFloat() - 0.6) * (double)this.pathFindDistance;
            double findZ = this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.pathFindDistance;
            if (this.getNavigation().getPath() != null && !blockedPath) {
                BlockPos destination = this.getNavigation().getPath().getTarget();
                this.pathfindPos = new Vec3((double)destination.getX(), (double)destination.getY(), (double)destination.getZ());
            } else if (target != null && !blockedPath) {
                if (this instanceof RangedAttackMob) {
                    boolean tooclose = this.distanceTo((Entity)target) < this.preferredDistance;
                    this.pathfindPos = new Vec3(findX + (double)(tooclose ? -1 : 1) * (target.getX() - this.getX()) / 3.0, findY + (target.getY() - this.getY() + (double)this.preferredHeight), findZ + (double)(tooclose ? -1 : 1) * (target.getZ() - this.getZ()) / 3.0);
                } else {
                    this.pathfindPos = target.position().add(0.0, 0.5, 0.0);
                }
            } else {
                this.pathfindPos = new Vec3(findX, findY, findZ);
            }
        } else if (target != null && !(this instanceof RangedAttackMob) && Math.sqrt(target.distanceToSqr(this.pathfindPos)) > 2.0) {
            this.pathfindPos = target.position().add(0.0, 0.5, 0.0);
        }
        double speed = this.getAttributeValue(Attributes.FLYING_SPEED);
        this.setDeltaMovement(this.getDeltaMovement().x + (this.pathfindPos.x - this.getX()) / 64.0 * speed, this.getDeltaMovement().y + (this.pathfindPos.y - this.getY()) / 64.0 * speed, this.getDeltaMovement().z + (this.pathfindPos.z - this.getZ()) / 64.0 * speed);
        double distanceX = this.pathfindPos.x - this.getX();
        double distanceZ = this.pathfindPos.z - this.getZ();
        this.yHeadRot = Utils.rotlerp(this.getYRot(), (float)(Mth.atan2((double)distanceZ, (double)distanceX) * 57.2957763671875) - 90.0f, 90.0f);
        this.zza = 0.5f;
        this.setYRot(this.getYRot() + Mth.wrapDegrees((float)((float)(Mth.atan2((double)this.getDeltaMovement().z, (double)this.getDeltaMovement().x) * 57.2957763671875) - 90.0f - this.getYRot())));
        if (Math.sqrt(this.distanceToSqr(this.pathfindPos)) < 1.0) {
            this.pathfindPos = null;
            if (this.getNavigation().getPath() != null && (double)this.getNavigation().getPath().getDistToTarget() < 1.5) {
                this.reachTarget();
                this.getNavigation().stop();
            }
        }
    }
}

