/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public class EntityBaseCadillion
extends EntityDivineMonster {
    private int chargeTime = 0;
    private int ramCooldown = 0;
    private boolean isCharging;

    public EntityBaseCadillion(EntityType<? extends EntityBaseCadillion> type, Level worldIn) {
        super(type, worldIn);
        this.followingTarget = false;
        this.isCharging = false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            return;
        }
        if (this.ramCooldown > 0) {
            --this.ramCooldown;
        }
        if (this.getTarget() != null) {
            if (this.isCharging) {
                ++this.chargeTime;
                if (this.chargeTime >= 20) {
                    double dz;
                    LivingEntity target = this.getTarget();
                    double targetX = target.getX();
                    double targetZ = target.getZ();
                    double dx = targetX - this.getX();
                    double distance = Math.sqrt(dx * dx + (dz = targetZ - this.getZ()) * dz);
                    if (distance > 0.0) {
                        double speed = 2.5;
                        double motionX = dx / distance * speed;
                        double motionZ = dz / distance * speed;
                        this.setDeltaMovement(motionX, 0.0, motionZ);
                    }
                    this.chargeTime = 0;
                    this.isCharging = false;
                    this.ramCooldown = 1200;
                }
            } else if (this.ramCooldown == 0) {
                this.getNavigation().stop();
                ++this.chargeTime;
                if (this.chargeTime >= 40) {
                    this.isCharging = true;
                    this.chargeTime = 0;
                }
            }
        } else {
            Player nearestPlayer = this.level().getNearestPlayer((Entity)this, this.getAttributeValue(Attributes.FOLLOW_RANGE));
            if (nearestPlayer != null && !nearestPlayer.isCreative()) {
                this.getNavigation().moveTo((Entity)nearestPlayer, 1.0);
            }
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.CADILLION.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }
}

