/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;

public class EntityLivingStatue
extends EntityDivineMonster
implements RangedAttackMob {
    public EntityLivingStatue(EntityType<? extends EntityLivingStatue> type, Level worldIn) {
        super(type, worldIn);
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.27, 10, 60.0f));
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null) {
            ItemStack weapon = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            ItemStack itemstack1 = this.getProjectile(weapon);
            AbstractArrow abstractarrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)(itemstack1.isEmpty() ? Items.ARROW.getDefaultInstance() : itemstack1), (float)distanceFactor, (ItemStack)(weapon.isEmpty() ? Items.BOW.getDefaultInstance() : weapon));
            abstractarrow.setBaseDamage(6.0);
            Item var7 = weapon.getItem();
            if (var7 instanceof ProjectileWeaponItem) {
                ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)var7;
                abstractarrow = weaponItem.customArrow(abstractarrow, itemstack1, weapon);
            }
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            abstractarrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 14.0f - (float)(this.level().getDifficulty().getId() << 2));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrow);
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.HIGH_HIT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.HIGH_HIT.get();
    }
}

