/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.arcana;

import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.entities.projectile.fireball.EntityFyracryxFireball;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;

public class EntityFyracryx
extends EntityDivineTameable
implements RangedAttackMob {
    public EntityFyracryx(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.DEATHCRYX.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.DEATHCRYX_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DEATHCRYX.get();
    }

    public void tick() {
        super.tick();
        if (this.getTarget() != null && !this.level().isClientSide && this.tickCount % 20 == 0) {
            this.performRangedAttack(this.getTarget(), 0.0f);
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            EntityFyracryxFireball projectile = new EntityFyracryxFireball(this.level(), (LivingEntity)this, target.xo - this.xo + this.random.nextGaussian() * (double)Mth.sqrt((float)this.distanceTo((Entity)this)) * 0.5, target.getBoundingBox().minY - this.xo, target.zo - this.zo + this.random.nextGaussian() * (double)Mth.sqrt((float)this.distanceTo((Entity)this)) * 0.5);
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            projectile.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }
}

