/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.effect.dimension;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import divinerpg.effect.dimension.TwilightSky;
import divinerpg.events.ClientSidedExtraEvents;
import divinerpg.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class IceikaSky
extends DimensionSpecialEffects {
    public static final ResourceLocation SUN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/particle/white_dwarf.png");
    public static final ResourceLocation MOON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/particle/ice_moon_phases.png");
    public static final ResourceLocation SNOW_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/snow.png");
    public static final ResourceLocation HAIL_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/environment/hail.png");
    public static final ResourceLocation BONEYARD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"boneyard");
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer starBuffer;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private boolean isRaining = false;
    private boolean isBoneyard = false;
    private boolean isBlizzard = false;
    private int lastTick;

    public IceikaSky() {
        super(256.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = Mth.sqrt((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        MeshData bufferbuilder$renderedbuffer = TwilightSky.drawStars(tesselator);
        this.starBuffer.bind();
        this.starBuffer.upload(bufferbuilder$renderedbuffer);
        VertexBuffer.unbind();
        tesselator = Tesselator.getInstance();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        bufferbuilder$renderedbuffer = TwilightSky.buildSkyDisc(tesselator, 16.0f);
        this.skyBuffer.bind();
        this.skyBuffer.upload(bufferbuilder$renderedbuffer);
        VertexBuffer.unbind();
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        float f = level.getRainLevel(partialTick);
        if (f > 0.0f) {
            lightTexture.turnOnLightLayer();
            int i = Mth.floor((double)camX);
            int j = Mth.floor((double)camY);
            int k = Mth.floor((double)camZ);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferbuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int l = Minecraft.useFancyGraphics() ? 10 : 5;
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            int i1 = -1;
            float f1 = (float)ticks + partialTick;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = k - l; j1 <= k + l; ++j1) {
                for (int k1 = i - l; k1 <= i + l; ++k1) {
                    double z;
                    double y;
                    double x;
                    int l1 = (j1 - k + 16) * 32 + k1 - i + 16;
                    double d0 = (double)this.rainSizeX[l1] * 0.5;
                    double d1 = (double)this.rainSizeZ[l1] * 0.5;
                    blockpos$mutableblockpos.set((double)k1, camY, (double)j1);
                    Biome biome = (Biome)level.getBiome((BlockPos)blockpos$mutableblockpos).value();
                    if (biome.getPrecipitationAt((BlockPos)blockpos$mutableblockpos) == Biome.Precipitation.NONE) continue;
                    int i2 = level.getHeight(Heightmap.Types.MOTION_BLOCKING, k1, j1);
                    int j2 = j - l;
                    int k2 = j + l;
                    if (j2 < i2) {
                        j2 = i2;
                    }
                    if (k2 < i2) {
                        k2 = i2;
                    }
                    int l2 = i2;
                    if (i2 < j) {
                        l2 = j;
                    }
                    if (j2 == k2) continue;
                    RandomSource randomsource = RandomSource.create((long)(k1 * k1 * 3121 + k1 * 45238971 ^ j1 * j1 * 418711 + j1 * 13761));
                    blockpos$mutableblockpos.set(k1, j2, j1);
                    byte precipitationType = Utils.ICEIKA_WEATHER;
                    if (precipitationType == 0) {
                        if (i1 != 0) {
                            if (i1 >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
                            }
                            i1 = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                            bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        float f5 = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
                        float f6 = (float)(randomsource.nextDouble() + (double)f1 * 0.01 * randomsource.nextGaussian());
                        float f7 = (float)(randomsource.nextDouble() + (double)f1 * randomsource.nextGaussian() * 0.001);
                        double d3 = (double)k1 + 0.5 - camX;
                        double d5 = (double)j1 + 0.5 - camZ;
                        float f8 = (float)(Math.sqrt(d3 * d3 + d5 * d5) / (double)l);
                        float f9 = ((1.0f - f8 * f8) * 0.3f + 0.5f) * f;
                        blockpos$mutableblockpos.set(k1, l2, j1);
                        int k3 = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        int l3 = k3 >> 16 & 0xFFFF;
                        int i4 = k3 & 0xFFFF;
                        int j4 = (l3 * 3 + 240) / 4;
                        int k4 = (i4 * 3 + 240) / 4;
                        bufferbuilder.addVertex((float)((double)k1 - camX - d0 + 0.5), (float)((double)k2 - camY), (float)((double)j1 - camZ - d1 + 0.5)).setUv(0.0f + f6, (float)j2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)((double)k1 - camX + d0 + 0.5), (float)((double)k2 - camY), (float)((double)j1 - camZ + d1 + 0.5)).setUv(1.0f + f6, (float)j2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)((double)k1 - camX + d0 + 0.5), (float)((double)j2 - camY), (float)((double)j1 - camZ + d1 + 0.5)).setUv(1.0f + f6, (float)k2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        bufferbuilder.addVertex((float)((double)k1 - camX - d0 + 0.5), (float)((double)j2 - camY), (float)((double)j1 - camZ - d1 + 0.5)).setUv(0.0f + f6, (float)k2 * 0.25f + f5 + f7).setColor(1.0f, 1.0f, 1.0f, f9).setUv2(k4, j4);
                        continue;
                    }
                    if (precipitationType == 1) {
                        if (i1 != 1) {
                            if (i1 >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
                            }
                            i1 = 1;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HAIL_LOCATION);
                            bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        int i3 = ticks + k1 * k1 * 3121 + k1 * 45238971 + j1 * j1 * 418711 + j1 * 13761 & 0x1F;
                        float f2 = -((float)i3 + partialTick) / 32.0f * (3.0f + randomsource.nextFloat());
                        double d2 = (double)k1 + 0.5 - camX;
                        double d4 = (double)j1 + 0.5 - camZ;
                        float f3 = (float)Math.sqrt(d2 * d2 + d4 * d4) / (float)l;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.set(k1, l2, j1);
                        int j3 = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockpos$mutableblockpos);
                        IceikaSky.uv2(bufferbuilder.addVertex((float)((double)k1 - camX - d0 + 0.5), (float)((double)k2 - camY), (float)((double)j1 - camZ - d1 + 0.5)).setUv(0.0f, (float)j2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4), j3);
                        IceikaSky.uv2(bufferbuilder.addVertex((float)((double)k1 - camX + d0 + 0.5), (float)((double)k2 - camY), (float)((double)j1 - camZ + d1 + 0.5)).setUv(1.0f, (float)j2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4), j3);
                        IceikaSky.uv2(bufferbuilder.addVertex((float)((double)k1 - camX + d0 + 0.5), (float)((double)j2 - camY), (float)((double)j1 - camZ + d1 + 0.5)).setUv(1.0f, (float)k2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4), j3);
                        IceikaSky.uv2(bufferbuilder.addVertex((float)((double)k1 - camX - d0 + 0.5), (float)((double)j2 - camY), (float)((double)j1 - camZ - d1 + 0.5)).setUv(0.0f, (float)k2 * 0.25f + f2).setColor(1.0f, 1.0f, 1.0f, f4), j3);
                        continue;
                    }
                    if (precipitationType != 2 || this.lastTick == ticks || Minecraft.getInstance().options.particles().get() == ParticleStatus.MINIMAL || !randomsource.nextBoolean() || !level.canSeeSky(new BlockPos((int)(x = camX + Math.random() * 38.0 - 19.0), (int)(y = camY + Math.random() * 16.0 - 8.0), (int)(z = camZ + Math.random() * 32.0 - 16.0)))) continue;
                    this.isBlizzard = true;
                    level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, true, x, y, z, 0.5, 0.1, 0.0);
                }
            }
            if (i1 >= 0) {
                BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.turnOffLightLayer();
        }
        this.lastTick = ticks;
        return true;
    }

    public static void uv2(VertexConsumer c, int j) {
        c.setUv2(j & 0xFFFF, j >> 16 & 0xFFFF);
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        return true;
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 vec, float f) {
        return vec.multiply((double)f * 0.94 + 0.06, (double)f * 0.94 + 0.06, (double)f * 0.91 + 0.09);
    }

    public boolean isFoggyAt(int x, int y) {
        return y < 128 && this.isRaining || this.isBoneyard;
    }

    @Nullable
    public float[] getSunriseColor(float f, float ff) {
        float[] color = super.getSunriseColor(f, ff);
        if (color == null) {
            return null;
        }
        return new float[]{color[0] * 0.2f, color[1] * 0.9f, color[2], color[3]};
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        if (this.isBlizzard && Utils.ICEIKA_WEATHER != 2 && level.canSeeSky(camera.getBlockPosition())) {
            this.isBlizzard = false;
            ClientSidedExtraEvents.MusicEvent.wantsToPlaySnowflakes = true;
        }
        this.isRaining = level.isRaining();
        this.isBoneyard = level.getBiome(camera.getBlockPosition()).is(BONEYARD_LOCATION);
        setupFog.run();
        if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !TwilightSky.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
            float f = (float)(vec3.x * 0.1);
            float f1 = (float)(vec3.y * 0.1);
            float f2 = (float)(vec3.z * 0.17);
            FogRenderer.levelFogColor();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderinstance = RenderSystem.getShader();
            this.skyBuffer.bind();
            this.skyBuffer.drawWithShader(modelViewMatrix, projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] afloat = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
            if (afloat != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(f3));
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                float f4 = afloat[0];
                float f5 = afloat[1];
                float f6 = afloat[2];
                BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                bufferbuilder.addVertex(modelViewMatrix, 0.0f, 100.0f, 0.0f).setColor(f4, f5, f6, afloat[3]);
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)((double)j * (Math.PI * 2) / 16.0);
                    float f8 = Mth.sin((float)f7);
                    float f9 = Mth.cos((float)f7);
                    bufferbuilder.addVertex(modelViewMatrix, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).setColor(afloat[0], afloat[1], afloat[2], 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
                modelViewMatrix.rotate((Quaternionfc)Axis.ZP.rotationDegrees(-f3));
                modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float f11 = 1.0f - level.getRainLevel(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
            float f12 = 30.0f;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(modelViewMatrix, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(modelViewMatrix, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(modelViewMatrix, f12, 100.0f, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(modelViewMatrix, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
            f12 = 20.0f;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
            int k = level.getMoonPhase();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)l / 4.0f;
            float f14 = (float)i1 / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.addVertex(modelViewMatrix, -f12, -100.0f, f12).setUv(f15, f16);
            bufferbuilder.addVertex(modelViewMatrix, f12, -100.0f, f12).setUv(f13, f16);
            bufferbuilder.addVertex(modelViewMatrix, f12, -100.0f, -f12).setUv(f13, f14);
            bufferbuilder.addVertex(modelViewMatrix, -f12, -100.0f, -f12).setUv(f15, f14);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
            modelViewMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * -360.0f));
            modelViewMatrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            float f10 = level.getStarBrightness(partialTick) * f11 + 0.5f;
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.setupNoFog();
            this.starBuffer.bind();
            this.starBuffer.drawWithShader(modelViewMatrix, projectionMatrix, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            setupFog.run();
            RenderSystem.setShaderColor((float)0.82f, (float)(0.85f + (afloat == null ? 0.0f : afloat[1] * 1.84f) * (0.398f - Math.abs(Mth.cos((float)(level.getTimeOfDay(partialTick) * ((float)Math.PI * 2)))))), (float)(0.92f + f2 * 1.4f), (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }
}

