/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.compat.jei.ingredient;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class BlockIngredientRenderer
implements IIngredientRenderer<Block> {
    public void render(GuiGraphics guiGraphics, Block ingredient) {
        BlockState state = ingredient.defaultBlockState();
        if (!state.isAir() && state.getFluidState().isEmpty()) {
            RenderSystem.enableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            ItemStack stack = state.getBlock().asItem().getDefaultInstance();
            if (!stack.isEmpty() && !state.is(BlockTags.FIRE)) {
                Font font = this.getFontRenderer(minecraft, ingredient);
                guiGraphics.renderFakeItem(stack, 0, 0);
                guiGraphics.renderItemDecorations(font, stack, 0, 0);
            } else {
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate(1.0f, 12.5f, 15.0f);
                poseStack.scale(10.0f, -10.0f, 10.0f);
                poseStack.rotateAround(Axis.XP.rotationDegrees(30.0f), 1.0f, 0.0f, 0.0f);
                poseStack.rotateAround(Axis.YP.rotationDegrees(45.0f), 0.0f, 1.0f, 0.0f);
                minecraft.getBlockRenderer().renderSingleBlock(state, poseStack, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.translucentMovingBlock());
                guiGraphics.flush();
                Lighting.setupFor3DItems();
                poseStack.popPose();
            }
            RenderSystem.disableBlend();
        }
    }

    public List<Component> getTooltip(Block ingredient, TooltipFlag tooltipFlag) {
        return List.of(ingredient.getName(), Component.literal((String)BuiltInRegistries.BLOCK.getKey((Object)ingredient).toString()).withStyle(ChatFormatting.DARK_GRAY));
    }
}

