/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.block_entities.chests.BoneChestBlockEntity;
import divinerpg.blocks.base.BlockModChest;
import divinerpg.client.models.block.ModelBoneChest;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderBoneChest
implements BlockEntityRenderer<BoneChestBlockEntity> {
    private final ModelBoneChest<?> model;

    public RenderBoneChest(BlockEntityRendererProvider.Context context) {
        this.model = new ModelBoneChest(context.bakeLayer(ModelBoneChest.LAYER_LOCATION));
    }

    public void render(BoneChestBlockEntity tile, float partialTick, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        matrix.mulPose(Axis.YP.rotationDegrees(-((Direction)tile.getBlockState().getValue((Property)BlockModChest.FACING)).toYRot()));
        matrix.mulPose(Axis.XN.rotationDegrees(180.0f));
        matrix.translate(-0.5, -0.5, -0.5);
        float lidAngle = tile.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        VertexConsumer builder = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/bone_chest.png")));
        this.model.handle.xRot = this.model.lid.xRot = -(lidAngle * 1.5707964f);
        this.model.renderToBuffer(matrix, builder, combinedLight, combinedOverlay);
        matrix.popPose();
    }
}

